<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\HowWorks;
use Illuminate\Support\Facades\Auth;

class HowItWorkController extends Controller
{
    public function index(Request $request)
    {
        $datas = HowWorks::where('vendor_id',1)->get();
        return view('admin.howwork.index',compact('datas'));
    }
    public function add(Request $request)
    {
        return view('admin.howwork.add');
    }
    public function edit(Request $request)
    {
        $data = HowWorks::where('id',$request->id)->first();
        return view('admin.howwork.edit',compact('data'));
    }
    public function save(Request $request)
    {
        $data = new HowWorks();
        $data->vendor_id = Auth::user()->id;
        $data->title = $request->title;
        $data->description = $request->description;
        if ($request->hasfile('image')) {
            $request->validate([
                'image' => 'image',
            ], [
                "image.image" => trans('messages.enter_image_file'),
            ]);
            $workimage = 'work-' . uniqid() . '.' . $request->image->getClientOriginalExtension();
            $request->image->move(storage_path('app/public/admin-assets/images/index/'), $workimage);
            $data->image = $workimage;
        }
        $data->save();
        return redirect('/admin/how_it_works')->with('success',trans('messages.success'));
    }
    public function update(Request $request)
    {
        $data = HowWorks::where('id',$request->id)->first();
        $data->vendor_id = Auth::user()->id;
        $data->title = $request->title;
        $data->description = $request->description;
        if ($request->hasfile('image')) {
            $request->validate([
                'image' => 'image',
            ], [
                "image.image" => trans('messages.enter_image_file'),
            ]);
            if (file_exists(storage_path('app/public/admin-assets/images/index/' . $data->image))) {
                @unlink(storage_path('app/public/admin-assets/images/index/' . $data->image));
            }
            $workimage = 'work-' . uniqid() . '.' . $request->image->getClientOriginalExtension();
            $request->image->move(storage_path('app/public/admin-assets/images/index/'), $workimage);
            $data->image = $workimage;
        }
        $data->update();
        return redirect('/admin/how_it_works')->with('success',trans('messages.success'));
    }
    public function delete(Request $request)
    {
        $data = HowWorks::where('id',$request->id)->first();
        if (file_exists(storage_path('app/public/admin-assets/images/index/' . $data->image))) {
            @unlink(storage_path('app/public/admin-assets/images/index/' . $data->image));
        }
        $data->delete();
        return redirect('/admin/how_it_works')->with('success',trans('messages.success'));
    }
}