<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Models\PricingPlan;
use App\Models\User;
use App\Models\Transaction;
use App\Models\SystemAddons;
use App\helper\helper;
use App\Models\Products;
use Stripe;
use Validator;
use PDF;
use Config;
use Illuminate\Support\Str;
class PlanPricingController extends Controller
{
    public function view_plan(Request $request)
    {
        if (SystemAddons::where('unique_identifier', 'subscription')->first() == null) {
                return redirect()->back()->with(['error' => 'You can not charge your end customers in regular license. Please purchase extended license to charge your end customers']);
        } else {
            $allplan = PricingPlan::orderBy('price');
            if (Auth::user()->type == 2 || Auth::user()->type == 4) {
                $allplan = $allplan->where('is_available', '1');
            }
            $allplan = $allplan->get();
            return view('admin.plan.plan', compact("allplan"));
        }
    }
    public function add_plan(Request $request)
    {
        return view('admin.plan.add_plan');
    }
    public function save_plan(Request $request)
    {
        $request->validate([
            'plan_name' => 'required',
            'plan_price' => 'required',
            'plan_duration' => 'required_if:type,1',
            'plan_max_business' => 'required_if:service_limit_type,1',
            'plan_description' => 'required',
            'plan_appoinment_limit' => 'required_if:booking_limit_type,1',
            'plan_days' => 'required_if:type,2',
        ], [
            'plan_name.required' => trans('messages.name_required'),
            'plan_price.required' => trans('messages.price_required'),
            'plan_duration.required_if' => trans('messages.duration_required'),
            'plan_max_business.required_if' => trans('messages.plan_max_business'),
            'plan_description.required' => trans('messages.description_required'),
            'plan_appoinment_limit.required_if' => trans('messages.appoinment_limit'),
            'plan_days.required_if' => trans('messages.days_required'),
        ]);
        $exitplan = PricingPlan::where('price', '0')->count();
        if ($exitplan > 0 && $request->plan_price == '0') {
            return redirect('admin/plan/add')->with('error', trans('messages.already_exist_plan'));
        } else {
            if ($request->custom_domain == "on") {
                $custom_domain = 1;
            } else {
                $custom_domain = "2";
            }
            if ($request->google_analytics == "on") {
                $google_analytics = 1;
            } else {
                $google_analytics = "2";
            }
            if ($request->pos == "on") {
                $pos = 1;
            } else {
                $pos = "2";
            }
            if ($request->vendor_app == "on") {
                $vendor_app = 1;
            } else {
                $vendor_app = "2";
            }
            if ($request->pwa == "on") {
                $pwa = 1;
            } else {
                $pwa = "2";
            }
            if ($request->employee == "on") {
                $employee = 1;
            } else {
                $employee = "2";
            }
            if ($request->customer_app == "on") {
                $customer_app = 1;
            } else {
                $customer_app = "2";
            }
            if ($request->coupons == "on") {
                $coupons = 1;
            } else {
                $coupons = "2";
            }
            if ($request->blogs == "on") {
                $blogs = 1;
            } else {
                $blogs = "2";
            }
            if ($request->whatsapp_message == "on") {
                $whatsapp_message = 1;
            } else {
                $whatsapp_message = "2";
            }
            if ($request->telegram_message == "on") {
                $telegram_message = 1;
            } else {
                $telegram_message = "2";
            }
            if ($request->social_logins == "on") {
                $social_logins = 1;
            } else {
                $social_logins = "2";
            }
            if ($request->sound_notification == "on") {
                $sound_notification = 1;
            } else {
                $sound_notification = "2";
            }
            if ($request->pixel == "on") {
                $pixel = 1;
            } else {
                $pixel = "2";
            }
            $saveplan = new PricingPlan();
            $saveplan->name = $request->plan_name;
            $saveplan->themes_id = "0";
            $saveplan->description = $request->plan_description;
            $saveplan->features = empty($request->plan_features)  ? null : implode("|", $request->plan_features);
            $saveplan->price = $request->plan_price;
            $saveplan->tax = $request->plan_tax;
            $saveplan->plan_type = $request->type;
            if ($request->type == "1") {
                $saveplan->duration = $request->plan_duration;
                $saveplan->days = "";
            }
            if ($request->type == "2") {
                $saveplan->duration = "";
                $saveplan->days = $request->plan_days;
            }
            if ($request->service_limit_type == "1") {
                $saveplan->order_limit = $request->plan_max_business;
            } elseif ($request->service_limit_type == "2") {
                $saveplan->order_limit = -1;
            }
            if ($request->booking_limit_type == "1") {
                $saveplan->appointment_limit = $request->plan_appoinment_limit;
            } elseif ($request->booking_limit_type == "2") {
                $saveplan->appointment_limit = -1;
            }
            $saveplan->custom_domain = $custom_domain;
            $saveplan->google_analytics = $google_analytics;
            $saveplan->pos = $pos;
            $saveplan->vendor_app = $vendor_app;
            $saveplan->customer_app = $customer_app;
            $saveplan->role_management = $employee;
            $saveplan->coupons = $coupons;
            $saveplan->pwa = $pwa;
            $saveplan->blogs = $blogs;
            $saveplan->whatsapp_message = $whatsapp_message;
            $saveplan->telegram_message = $telegram_message;
            $saveplan->social_logins = $social_logins;
            $saveplan->sound_notification = $sound_notification;
            $saveplan->pixel = $pixel;
            $saveplan->themes_id = implode(",", $request->themecheckbox);
            $saveplan->save();
            return redirect('admin/plan')->with('success', trans('messages.success'));
        }
    }
    public function edit_plan($id)
    {
        $editplan = PricingPlan::where('id', $id)->first();
        return view('admin.plan.edit_plan', compact("editplan"));
    }
    public function update_plan(Request $request, $id)
    {
        $request->validate([
            'plan_name' => 'required',
            'plan_price' => 'required',
            'plan_duration' => 'required_if:type,1',
            'plan_max_business' => 'required_if:service_limit_type,1',
            'plan_description' => 'required',
            'plan_appoinment_limit' => 'required_if:booking_limit_type,1',
            'plan_days' => 'required_if:type,2',
        ], [
            'plan_name.required' => trans('messages.name_required'),
            'plan_price.required' =>  trans('messages.price_required'),
            'plan_duration.required_if' => trans('messages.plan_duration'),
            'plan_max_business.required_if' => trans('messages.plan_max_business'),
            'plan_description.required' => trans('messages.description_required'),
            'plan_appoinment_limit.required_if' => trans('messages.appoinment_limit'),
            'plan_days.required_if' => trans('messages.days_required'),
        ]);
        if ($request->custom_domain == "on") {
            $custom_domain = 1;
        } else {
            $custom_domain = "2";
        }
        if ($request->google_analytics == "on") {
            $google_analytics = 1;
        } else {
            $google_analytics = "2";
        }
        if ($request->pos == "on") {
            $pos = 1;
        } else {
            $pos = "2";
        }
        if ($request->vendor_app == "on") {
            $vendor_app = 1;
        } else {
            $vendor_app = "2";
        }
        if ($request->pwa == "on") {
            $pwa = 1;
        } else {
            $pwa = "2";
        }
        if ($request->employee == "on") {
            $employee = 1;
        } else {
            $employee = "2";
        }
        if ($request->customer_app == "on") {
            $customer_app = 1;
        } else {
            $customer_app = "2";
        }
        if ($request->coupons == "on") {
            $coupons = 1;
        } else {
            $coupons = "2";
        }
        if ($request->blogs == "on") {
            $blogs = 1;
        } else {
            $blogs = "2";
        }
        if ($request->social_logins == "on") {
            $social_logins = 1;
        } else {
            $social_logins = "2";
        }
        if ($request->sound_notification == "on") {
            $sound_notification = 1;
        } else {
            $sound_notification = "2";
        }
        if ($request->whatsapp_message == "on") {
            $whatsapp_message = 1;
        } else {
            $whatsapp_message = "2";
        }
        if ($request->telegram_message == "on") {
            $telegram_message = 1;
        } else {
            $telegram_message = "2";
        }
        if ($request->pixel == "on") {
            $pixel = 1;
        } else {
            $pixel = "2";
        }
        $exitplan = PricingPlan::where('price', '0')->count();
        if ($exitplan > 1 && $request->plan_price == '0') {
            return redirect('admin/plan/edit-' . $id)->with('error', trans('messages.already_exist_plan'));
        } else {
            $editplan = PricingPlan::where('id', $id)->first();
            $editplan->name = $request->plan_name;
            $editplan->themes_id = "0";
            $editplan->description = $request->plan_description;
            $editplan->features = empty($request->plan_features)  ? null : implode("|", $request->plan_features);
            $editplan->price = $request->plan_price;
            $editplan->tax = $request->plan_tax;
            $editplan->plan_type = $request->type;
            if ($request->type == "1") {
                $editplan->duration = $request->plan_duration;
                $editplan->days = "";
            }
            if ($request->type == "2") {
                $editplan->duration = "";
                $editplan->days = $request->plan_days;
            }
            if ($request->service_limit_type == "1") {
                $editplan->order_limit = $request->plan_max_business;
            } elseif ($request->service_limit_type == "2") {
                $editplan->order_limit = -1;
            }
            if ($request->booking_limit_type == "1") {
                $editplan->appointment_limit = $request->plan_appoinment_limit;
            } elseif ($request->booking_limit_type == "2") {
                $editplan->appointment_limit = -1;
            }
            $editplan->custom_domain = $custom_domain;
            $editplan->google_analytics = $google_analytics;
            $editplan->pos = $pos;
            $editplan->vendor_app = $vendor_app;
            $editplan->customer_app = $customer_app;
            $editplan->role_management = $employee;
            $editplan->pwa = $pwa;
            $editplan->coupons = $coupons;
            $editplan->blogs = $blogs;
            $editplan->social_logins = $social_logins;
            $editplan->sound_notification = $sound_notification;
            $editplan->whatsapp_message = $whatsapp_message;
            $editplan->telegram_message = $telegram_message;
            $editplan->pixel = $pixel;
            $editplan->themes_id = implode(",", $request->themecheckbox);
            $editplan->update();
            return redirect('admin/plan')->with('success', trans('messages.success'));
        }
    }
    public function status_change($id, $status)
    {
        PricingPlan::where('id', $id)->update(['is_available' => $status]);
        return redirect('admin/plan')->with('success', trans('messages.success'));
    }
    public function select_plan($id)
    {
        if (Auth::user()->type == 4) {
            $vendor_id = Auth::user()->vendor_id;
        } else {
            $vendor_id = Auth::user()->id;
        }
        $plan = PricingPlan::where('id', $id)->first();
        $totalproduct = Products::where('vendor_id', $vendor_id)->count();
        if (!empty($totalproduct)) {
            if ($plan->order_limit != -1) {
                if ($plan->order_limit < $totalproduct) {
                    return redirect('admin/plan')->with('error', trans('messages.not_eligible_for_plan'));
                }
            }
        }
        $checkbanktransfer = helper::checkplan($vendor_id, '');
        $data = json_decode(json_encode($checkbanktransfer), true);
        if (@$data['original']['status'] == 2 && @$data['original']['bank_transfer'] == 1) {
            return redirect('admin/plan')->with('error', @$data['original']['message']);
        }
        if ($plan->price > 0) {
            $paymentmethod = Payment::where('vendor_id', 1)->where('is_available', '1')->where('is_activate', 1)->get();
            return view('admin.plan.plan_payment', compact('plan', 'paymentmethod'));
        } else {
            $transaction = new Transaction;
            $transaction->vendor_id = $vendor_id;
            $transaction->plan_name = $plan->name;
            $transaction->plan_id = $id;
            $transaction->payment_type = "";
            $transaction->amount = $plan->price;
            $transaction->offer_code = "";
            $transaction->offer_amount =  "";
            $transaction->grand_total =  $plan->price + $plan->tax;
            $transaction->tax = $plan->tax == null ? 0 : $plan->tax;
            $transaction->payment_id = "";
            $transaction->service_limit = $plan->order_limit;
            $transaction->appoinment_limit = $plan->appointment_limit;
            $transaction->expire_date = helper::get_plan_exp_date($plan->duration, $plan->days);
            $transaction->duration = $plan->duration;
            $transaction->days = $plan->days;
            $transaction->custom_domain = $plan->custom_domain;
            $transaction->google_analytics = $plan->google_analytics;
            $transaction->pos = $plan->pos;
            $transaction->vendor_app = $plan->vendor_app;
            $transaction->themes_id = $plan->themes_id;
            $transaction->purchase_date = date("Y-m-d h:i:sa");
            $transaction->customer_app = $plan->customer_app;
            $transaction->role_management = $plan->role_management;
            $transaction->pwa = $plan->pwa;
            $transaction->coupons = $plan->coupons;
            $transaction->blogs = $plan->blogs;
            $transaction->social_logins = $plan->social_logins;
            $transaction->sound_notification = $plan->sound_notification;
            $transaction->whatsapp_message = $plan->whatsapp_message;
            $transaction->telegram_message = $plan->telegram_message;
            $transaction->pixel = $plan->pixel;
            $transaction->features = $plan->features;
            $transaction->transaction_number = Str::upper(Str::random(8));
            $transaction->save();
            session()->forget('discount_data');
            User::where('id', $vendor_id)->update(['plan_id' => $id, 'purchase_amount' => $plan->price, 'purchase_date' => Carbon::now()->toDateTimeString()]);
            $emaildata = helper::emailconfigration(helper::appdata('')->id);
            Config::set('mail',$emaildata);
            helper::send_subscription_email(Auth::user()->email, Auth::user()->name, $plan->name, helper::get_plan_exp_date($plan->duration, $plan->days), helper::currency_formate($plan->price, ""), "-", "-");
            return redirect()->back()->with('success', trans('messages.success'));
        }
    }
    public function success(Request $request)
    {
        try {
            if (Auth::user()->type == 4) {
                $vendor_id = Auth::user()->vendor_id;
            } else {
                $vendor_id = Auth::user()->id;
            }
            if (@$request->status_id == 3) {
                return redirect('admin/plan')->with('success', trans('messages.wrong'));
            }

            if (@$request->paymentId != "") {
                $paymentid = $request->paymentId;
            }
            if (@$request->payment_id != "") {
                $paymentid = $request->payment_id;
            }
            if (@$request->transaction_id != "") {
                $paymentid = $request->transaction_id;
            }

            $plan = PricingPlan::where('id', session()->get('plan_id'))->first();
            $checkuser = User::find(Auth::user()->id);
            $checkuser->plan_id = session()->get('plan_id');
            $checkuser->purchase_amount = session()->get('amount');
            $checkuser->purchase_date = date("Y-m-d h:i:sa");
            $checkuser->save();
            $transaction = new Transaction;
            $transaction->vendor_id = $vendor_id;
            $transaction->plan_name = $plan->name;
            $transaction->plan_id = session()->get('plan_id');
            $transaction->payment_type = session()->get('payment_type');
            $transaction->amount = $plan->price;
            if (session()->has('discount_data')) {
                $transaction->offer_code = session()->get('discount_data')['offer_code'];
                $transaction->offer_amount = session()->get('discount_data')['offer_amount'];
            }
            $transaction->tax = $plan->tax == null ? 0 : $plan->tax;
            $transaction->grand_total =  session()->get('amount');
            $transaction->payment_id = @$paymentid;
            $transaction->service_limit = $plan->order_limit;
            $transaction->appoinment_limit = $plan->appointment_limit;
            $transaction->expire_date = helper::get_plan_exp_date($plan->duration, $plan->days);
            $transaction->duration = $plan->duration;
            $transaction->days = $plan->days;
            $transaction->custom_domain = $plan->custom_domain;
            $transaction->google_analytics = $plan->google_analytics;
            $transaction->pos = $plan->pos;
            $transaction->vendor_app = $plan->vendor_app;
            $transaction->status = "2";
            $transaction->themes_id = $plan->themes_id;
            $transaction->purchase_date = date("Y-m-d h:i:sa");
            $transaction->customer_app = $plan->customer_app;
            $transaction->role_management = $plan->role_management;
            $transaction->pwa = $plan->pwa;
            $transaction->coupons = $plan->coupons;
            $transaction->blogs = $plan->blogs;
            $transaction->social_logins = $plan->social_logins;
            $transaction->sound_notification = $plan->sound_notification;
            $transaction->whatsapp_message = $plan->whatsapp_message;
            $transaction->telegram_message = $plan->telegram_message;
            $transaction->pixel = $plan->pixel;
            $transaction->features = $plan->features;
            $transaction->transaction_number = Str::upper(Str::random(8));
            $transaction->save();
            if (session()->get('payment_type') == "1") {
                $payment_type = "cod";
            }
            if (session()->get('payment_type') == 2) {
                $payment_type = "razorpay";
            }
            if (session()->get('payment_type') == 3) {
                $payment_type = "stripe";
            }
            if (session()->get('payment_type') == 5) {
                $payment_type = "paystack";
            }
            if (session()->get('payment_type') == 7) {
                $payment_type = "mercadopago";
            }
            if (session()->get('payment_type') == 8) {
                $payment_type = "paypal";
            }
            if (session()->get('payment_type') == 9) {
                $payment_type = "myfatoorah";
            }
            if (session()->get('payment_type') == 10) {
                $payment_type = "toyyibpay";
            }
            if (session()->get('payment_type') == 6) {
                $payment_type = 'banktransfer';
            }
            $emaildata = helper::emailconfigration(helper::appdata('')->id);
            Config::set('mail',$emaildata);
            helper::send_subscription_email(Auth::user()->email, Auth::user()->name, $plan->name, helper::get_plan_exp_date($plan->duration, $plan->days), helper::currency_formate($plan->price, ""), $payment_type, @$paymentid);

            session()->forget(['amount', 'plan_id', 'payment_type', 'currency', 'returnUrl', 'successurl', 'failureurl', 'discount_data']);

            return redirect('admin/plan')->with('success', trans('messages.success'));
        } catch (\Throwable $th) {
            return redirect('admin/plan')->with('success', trans('messages.wrong'));
        }
    }
    public function buyplan(Request $request)
    {
        try {

            if (Auth::user()->type == 4) {
                $vendor_id = Auth::user()->vendor_id;
            } else {
                $vendor_id = Auth::user()->id;
            }
            $plan = PricingPlan::where('id', $request->plan_id)->first();
            if (strtolower($request->payment_type) == '3') {
                $paymentmethod = Payment::where('payment_name', $request->payment_type)->where('is_available', 1)->first();
                Stripe\Stripe::setApiKey($paymentmethod->secret_key);
                $charge = Stripe\Charge::create([
                    'amount' => $request->amount * 100,
                    'currency' => $request->currency,
                    'description' => 'Plan Subscription',
                    'source' => $request->payment_id,
                ]);
                $payment_id = $charge->id;
            } else {
                $payment_id = $request->payment_id;
            }
            if (strtolower($request->payment_type) == '6') {
                if ($request->hasFile('screenshot')) {
                    $validator = Validator::make($request->all(), [
                        'screenshot' => 'image|mimes:jpg,jpeg,png',
                    ], [
                        'screenshot.mage' => trans('messages.enter_image_file'),
                        'screenshot.mimes' => trans('messages.valid_image'),
                    ]);
                    if ($validator->fails()) {
                        return redirect()->back()->withErrors($validator)->withInput();
                    } else {
                        $filename = 'screenshot-' . uniqid() . "." . $request->file('screenshot')->getClientOriginalExtension();
                        $request->file('screenshot')->move(env('ASSETPATHURL') . 'admin-assets/images/screenshot/', $filename);
                    }
                }
                $payment_id = "";
                $status = 1;
            }elseif($request->payment_type == "1" || $request->payment_type == '6'){
                $status = 1;
            } else {
                $status = 2;
            }
            $checkuser = User::find(Auth::user()->id);
            $checkuser->plan_id = $request->plan_id;
            $checkuser->purchase_amount = $request->amount;
            $checkuser->purchase_date = date("Y-m-d h:i:sa");
            $checkuser->save();
            $transaction = new Transaction();
            if ($request->payment_type == '6') {
                $transaction->screenshot = $filename;
            }
            $transaction->vendor_id = $vendor_id;
            $transaction->plan_name = $plan->name;
            $transaction->plan_id = $request->plan_id;
            $transaction->payment_type = $request->payment_type;
            $transaction->payment_id = $payment_id;
            $transaction->amount= $plan->price;
            $transaction->offer_code = $request->offer_code;
            $transaction->offer_amount = $request->discount;
            $transaction->grand_total = $request->amount;
            $transaction->tax = $plan->tax == null ? 0 : $plan->tax;
            $transaction->service_limit = $plan->order_limit;
            $transaction->appoinment_limit = $plan->appointment_limit;
            $transaction->status = $status;
            $transaction->purchase_date = date("Y-m-d h:i:sa");
            $transaction->expire_date = helper::get_plan_exp_date($plan->duration, $plan->days);
            $transaction->duration = $plan->duration;
            $transaction->days = $plan->days;
            $transaction->themes_id = $plan->themes_id;
            $transaction->custom_domain = $plan->custom_domain;
            $transaction->google_analytics = $plan->google_analytics;
            $transaction->pos = $plan->pos;
            $transaction->vendor_app = $plan->vendor_app;
            $transaction->customer_app = $plan->customer_app;
            $transaction->role_management = $plan->role_management;
            $transaction->pwa = $plan->pwa;
            $transaction->coupons = $plan->coupons;
            $transaction->blogs = $plan->blogs;
            $transaction->social_logins = $plan->social_logins;
            $transaction->sound_notification = $plan->sound_notification;
            $transaction->whatsapp_message = $plan->whatsapp_message;
            $transaction->telegram_message = $plan->telegram_message;
            $transaction->features = $plan->features;
            $transaction->pixel = $plan->pixel;
            $transaction->transaction_number = Str::upper(Str::random(8));
            $transaction->save();
            session()->forget('discount_data');
            if ($request->payment_type == "1") {
                $emaildata = helper::emailconfigration(helper::appdata('')->id);
                Config::set('mail',$emaildata);
                helper::cod_request(Auth::user()->email, Auth::user()->name, $plan->name, helper::get_plan_exp_date($plan->duration, $plan->days), helper::currency_formate($plan->price, ""), $request->payment_type, @$payment_id);
                return redirect('admin/plan')->with('success', trans('messages.success'));
            } 
            elseif ($request->payment_type == '6' || strtolower($request->payment_type) == "1") {
                $emaildata = helper::emailconfigration(helper::appdata('')->id);
                Config::set('mail',$emaildata);
                helper::bank_transfer_request(Auth::user()->email, Auth::user()->name, $plan->name, helper::get_plan_exp_date($plan->duration, $plan->days), helper::currency_formate($plan->price, ""), $request->payment_type, @$payment_id);
                return redirect('admin/plan')->with('success', trans('messages.success'));
            } else {
                $emaildata = helper::emailconfigration(helper::appdata('')->id);
                Config::set('mail',$emaildata);
                helper::send_subscription_email(Auth::user()->email, Auth::user()->name, $plan->name, helper::get_plan_exp_date($plan->duration, $plan->days), helper::currency_formate($plan->price, ""), $request->payment_type, @$payment_id);
                return response()->json(['status' => 1, 'message' => trans('messages.success')], 200);
            }
        } catch (\Throwable $th) {
            if ($request->payment_type == '6') {
                return redirect()->back()->with('error', trans('messages.wrong'));
            } else {
                return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
            }
        }
    }
    public function delete(Request $request)
    {
        $deleteplan = PricingPlan::where('id', $request->id)->first();
        $deleteplan->delete();
        return redirect('admin/plan')->with('success', trans('messages.success'));
    }
    public function plan_details(Request $request)
    {
        $plan = Transaction::with('vendor_info','plan_info')->where('id', $request->id)->first();
        return view('admin.plan.plan_details', compact('plan'));
    }
    public function generatepdf(Request $request)
    {
        $plan = Transaction::where('id', $request->id)->first();
        $user = User::where('id',$plan->vendor_id)->first();
        $pdf = PDF::loadView('admin.plan.plandetailspdf',['plan'=> $plan,'user'=>$user]);
        return $pdf->download('transaction.pdf');
    }
    public function updateimage(Request $request)
    {
        if ($request->has('theme_image')) {
            if (file_exists(storage_path('app/public/admin-assets/images/theme/' . $request->theme_image))) {
                unlink(storage_path('app/public/admin-assets/images/theme/' . $request->theme_image));
            }
            if($request->image_id == 1)
            {
                $theme_image = 'theme-1.png';
            }
            if($request->image_id == 2)
            {
                $theme_image = 'theme-2.png';
            }
            if($request->image_id == 3)
            {
                $theme_image = 'theme-3.png';
            }
            if($request->image_id == 4)
            {
                $theme_image = 'theme-4.png';
            }
            if($request->image_id == 5)
            {
                $theme_image = 'theme-5.png';
            }
            if($request->image_id == 6)
            {
                $theme_image = 'theme-6.png';
            }
            if($request->image_id == 7)
            {
                $theme_image = 'theme-7.png';
            }
            if($request->image_id == 8)
            {
                $theme_image = 'theme-8.png';
            }
            if($request->image_id == 9)
            {
                $theme_image = 'theme-9.png';
            }
            if($request->image_id == 10)
            {
                $theme_image = 'theme-10.png';
            }
            $request->file('theme_image')->move(storage_path('app/public/admin-assets/images/theme/'), $theme_image);
            return redirect()->back()->with('success', trans('messages.success'));
        } else {
            return redirect()->back()->with('error', trans('messages.wrong'));
        }
    }
}
