@extends('admin.layout.default')
@php
    if (Auth::user()->type == 4) {
        $vendor_id = Auth::user()->vendor_id;
    } else {
        $vendor_id = Auth::user()->id;
    }
@endphp
@section('content')
    <div class="d-flex justify-content-between align-items-center">
        <h5 class="text-uppercase">{{ trans('labels.products') }}</h5>
        <div class="d-flex">
            <a href="{{ URL::to('admin/products/add') }}"
                class="btn btn-secondary px-2 d-flex {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'add') == 1 ? '' : 'd-none') : '' }}">
                <i class="fa-regular fa-plus mx-1"></i>{{ trans('labels.add') }}
            </a>
            <a class="btn btn-success mx-2 {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'add') == 1 ? '' : 'd-none') : '' }}"
                href="{{ URL::to('admin/products/import') }}">{{ trans('labels.import') }}</a>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12">
            <div class="card border-0">
                <div class="card-body">
                    <div class="table-responsive fw-500">
                        <table class="table table-striped table-bordered py-3 zero-configuration w-100">
                            <thead>
                                <tr class="text-uppercase">
                                    <td>{{ trans('labels.srno') }}</td>
                                    <td>{{ trans('labels.image') }}</td>
                                    <td>{{ trans('labels.category') }}</td>
                                    <td>{{ trans('labels.name') }}</td>
                                    <td>{{ trans('labels.price') }}</td>
                                    <td>{{ trans('labels.tax') }}</td>
                                    <td>{{ trans('labels.top_deals') }}</td>
                                    <td>{{ trans('labels.status') }}</td>
                                    <td>{{ trans('labels.action') }}</td>
                                </tr>
                            </thead>
                            <tbody id="tabledetails" data-url="{{ url('admin/products/reorder_category') }}">
                                @php $i = 1; @endphp
                                @foreach ($getproductslist as $product)
                                    <tr class="fs-7 row1" id="dataid{{ $product->id }}" data-id="{{ $product->id }}">
                                        <td>@php echo $i++; @endphp</td>
                                        <td>
                                            @if ($product['product_image'] == null)
                                                <img src="{{ helper::image_path('product.png') }}"
                                                    class="img-fluid rounded hw-50" alt="">
                                            @else
                                                <img src="{{ @$product['product_image']->image_url }}"
                                                    class="img-fluid rounded hw-50" alt="">
                                            @endif
                                        </td>
                                        <td>{{ $product['category_info']->name }}</td>
                                        <td>{{ $product->name }} <br>
                                            @if ($product->has_variants == 1)
                                                <small
                                                    class="fw-bold text-muted">{{ $product->has_variation == 1 ? trans('labels.customizable') : '' }}</small>
                                            @endif
                                            @if (helper::checklowqty($product->id, $product->vendor_id) == 1)
                                                <span class="badge bg-danger">{{ trans('labels.low_qty') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ helper::currency_formate($product->price, $vendor_id) }}</td>
                                        <td>{{ $product->tax }}%</td>
                                        <td>
                                            @if ($product->top_deals == '1')
                                            <a tooltip="{{ trans('labels.remove_from_topdeals') }}"
                                            @if (env('Environment') == 'sendbox') onclick="myFunction()" @else onclick="statusupdate('{{ URL::to('admin/products/top_deals-' . $product->slug . '/2') }}')" @endif
                                                    class="btn btn-sm btn-outline-success {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}"><i
                                                        class="fa-regular fa-check"></i></a>
                                            @else
                                            <a  tooltip="{{ trans('labels.add_to_topdeals') }}"
                                            @if (env('Environment') == 'sendbox') onclick="myFunction()" @else  onclick="statusupdate('{{ URL::to('admin/products/top_deals-' . $product->slug . '/1') }}')" @endif
                                            class="btn btn-sm btn-outline-danger {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}"><i
                                                class="fa-regular fa-xmark"></i></a>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($product->is_available == '1')
                                                <a tooltip="{{ trans('labels.active') }}"
                                                @if (env('Environment') == 'sendbox') onclick="myFunction()" @else  onclick="statusupdate('{{ URL::to('admin/products/status_change-' . $product->slug . '/2') }}')" @endif
                                                    class="btn btn-sm btn-outline-success {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}"><i
                                                        class="fa-regular fa-check"></i></a>
                                            @else
                                                <a tooltip="{{ trans('labels.inactive') }}"
                                                @if (env('Environment') == 'sendbox') onclick="myFunction()" @else onclick="statusupdate('{{ URL::to('admin/products/status_change-' . $product->slug . '/1') }}')" @endif
                                                    class="btn btn-sm btn-outline-danger {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}"><i
                                                        class="fa-regular fa-xmark"></i></a>
                                            @endif
                                        </td>
                                        <td>
                                            <a tooltip="{{ trans('labels.edit') }}"
                                                class="btn btn-outline-info btn-sm {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'edit') == 1 ? '' : 'd-none') : '' }}"
                                                href="{{ URL::to('admin/products/edit-' . $product->slug) }}"> <i
                                                    class="fa-regular fa-pen-to-square"></i></a>
                                            <a tooltip="{{ trans('labels.delete') }}"
                                                class="btn btn-outline-danger btn-sm {{ Auth::user()->type == 4 ? (helper::check_access('role_products', Auth::user()->role_id, Auth::user()->vendor_id, 'delete') == 1 ? '' : 'd-none') : '' }}"
                                                @if (env('Environment') == 'sendbox') onclick="myFunction()" @else onclick="statusupdate('{{ URL::to('admin/products/delete-' . $product->slug) }}')" @endif> 
                                                <i class="fa-regular fa-trash"></i></a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
