@extends('admin.layout.default')
@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="text-uppercase">{{ trans('labels.edit') }}</h5>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ URL::to('admin/whoweare') }}">{{ trans('labels.who_we_are') }}</a>
            </li>
            <li class="breadcrumb-item active {{ session()->get('direction') == 2 ? 'breadcrumb-rtl' : '' }}"
                aria-current="page">{{ trans('labels.edit') }}</li>
        </ol>
    </nav>
</div>
        <div class="row">
            <div class="col-12">
                <div class="card border-0 box-shadow">
                    <div class="card-body">
                        <form action="{{URL::to('/admin/whoweare/update-'.$editwork->id)}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="form-label">{{trans('labels.title')}}<span class="text-danger"> * </span></label>
                                    <input type="text" class="form-control" name="title" value="{{$editwork->title}}" placeholder="{{trans('labels.title')}}" required>
                                    @error('title')
                                    <span class="text-danger">{{ $message }}</span> 
                                 @enderror
                                </div>
                                <div class="col-md-6 form-group">
                                        <label class="form-label">{{trans('labels.image')}}<span class="text-danger"> * </span></label>
                                        <input type="file" class="form-control" name="image">
                                        @error('image')
                                        <span class="text-danger">{{ $message }}</span> 
                                     @enderror
                                    <img src="{{helper::image_path($editwork->image)}}" class="img-fluid rounded hw-70 mt-1" alt="">
                                </div>
                                <div class="form-group">
                                    <label class="form-label">{{trans('labels.description')}}<span class="text-danger"> * </span></label>
                                    <textarea class="form-control" name="description" placeholder="{{trans('labels.description')}}" rows="5">{{$editwork->sub_title}}</textarea>
                                    @error('description')
                                    <span class="text-danger">{{ $message }}</span> 
                                 @enderror
                                </div>
                            
                               
                            </div>
                            <div class="form-group text-end">
                                <a href="{{ URL::to('admin/choose_us') }}"
                                    class="btn btn-outline-danger">{{ trans('labels.cancel') }}</a>
                                <button
                                    @if (env('Environment') == 'sendbox') type="button" onclick="myFunction()" @else type="submit" @endif
                                    class="btn btn-secondary {{ Auth::user()->type == 4 ? (helper::check_access('role_who_we_are', Auth::user()->role_id, $vendor_id, 'edit') == 1  ? '' : 'd-none') : '' }}">{{ trans('labels.save') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
@endsection