@extends('web.layout.default')

@section('contents')
    <!-- BREADCRUMB AREA START -->

    <section class="py-5 mb-5 bg-light">

        <div class="container">

            <nav aria-label="breadcrumb">

                <h2 class="breadcrumb-title mb-2">{{ trans('labels.shopping_cart') }}</h2>

                <ol class="breadcrumb justify-content-center">

                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}"><a
                            class="text-dark" href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                    </li>

                    <li class="text-muted {{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active"
                        aria-current="page">{{ trans('labels.cart') }}</li>

                </ol>

            </nav>

        </div>

    </section>

    <!-- BREADCRUMB AREA END -->

    <!-- CART AREA START -->

    <section class="cart">

        <div class="container">

            @if (count($getcartlist) > 0)

                <div class="row">

                    <div class="col-lg-8 mb-3">

                        <div class="card border-0">

                            <div class="card-body p-0">
                                <table class="table cart-table m-md-0">
                                    <thead>
                                        <tr>
                                            <th class="d-none d-sm-table-cell bg-light">{{ trans('labels.product') }}</th>
                                            <th class="d-none d-sm-table-cell bg-light">{{ trans('labels.price') }}</th>
                                            <th class="d-none d-md-table-cell bg-light">{{ trans('labels.quantity') }}</th>
                                            <th class="d-none d-md-table-cell bg-light">{{ trans('labels.total') }}</th>
                                            <th class="d-none d-md-table-cell bg-light">{{ trans('labels.remove') }}</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        @php
                                            
                                            $subtotal = 0;
                                            
                                            $totaltax = 0;
                                            
                                        @endphp

                                        @foreach ($getcartlist as $cartdata)
                                            @php
                                                
                                                $subtotal += $cartdata->product_price * $cartdata->qty;
                                                
                                                $totaltax += $cartdata->product_tax * $cartdata->qty;
                                                
                                            @endphp
                                            <tr>
                                                <td class="px-0 px-sm-2">
                                                    <div class="product-detail">
                                                        <img class="pr-img"
                                                            src="{{ helper::image_path($cartdata->product_image) }}"
                                                            alt="image">
                                                        <div class="details">
                                                            <a class="cart_title" href="#">
                                                                <p class="text-dark">{{ $cartdata->product_name }}</p>

                                                                @if ($cartdata->variation_id > 0)
                                                                    <p class="mb-2 text-dark"> {{ $cartdata->attribute }} :
                                                                        <small
                                                                            class="text-muted">{{ $cartdata->variation_name }}</small>
                                                                    </p>
                                                                @else
                                                                    -
                                                                @endif
                                                            </a>
                                                            <div class="d-flex align-items-center justify-content-between">
                                                                <span
                                                                    class="size gap-2 d-flex d-sm-none">{{ trans('labels.price') }}
                                                                    :
                                                                    <span>{{ helper::currency_formate($cartdata->product_price, $cartdata->vendor_id) }}</span>
                                                                </span>
                                                                <div class="item-quantity d-lg-none">

                                                                    <a class="btn border-0 minus"
                                                                        href="{{ URL::to(@$vendordata->slug . '/cart/qtyupdate-' . $cartdata->product_id . '-' . $cartdata->variation_id . '-minus') }}"><i
                                                                            class="fa-regular fa-minus"></i></a>

                                                                    <input type="text" value="{{ $cartdata->qty }}"
                                                                        readonly>

                                                                    <a class="btn border-0 plus"
                                                                        href="{{ URL::to(@$vendordata->slug . '/cart/qtyupdate-' . $cartdata->product_id . '-' . $cartdata->variation_id . '-plus') }}"><i
                                                                            class="fa-regular fa-plus"></i></a>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>

                                                <td class="price d-none d-sm-table-cell">
                                                    {{ helper::currency_formate($cartdata->product_price, $cartdata->vendor_id) }}
                                                </td>
                                                <td class="d-none d-md-table-cell">
                                                    <div class="item-quantity">

                                                        <a class="btn border-0 minus"
                                                            href="{{ URL::to(@$vendordata->slug . '/cart/qtyupdate-' . $cartdata->product_id . '-' . $cartdata->variation_id . '-minus') }}"><i
                                                                class="fa-regular fa-minus"></i></a>

                                                        <input type="text" value="{{ $cartdata->qty }}" readonly>

                                                        <a class="btn border-0 plus"
                                                            href="{{ URL::to(@$vendordata->slug . '/cart/qtyupdate-' . $cartdata->product_id . '-' . $cartdata->variation_id . '-plus') }}"><i
                                                                class="fa-regular fa-plus"></i></a>

                                                    </div>
                                                </td>
                                                <td class="total d-none d-md-table-cell">
                                                    {{ helper::currency_formate($cartdata->product_price * $cartdata->qty, $cartdata->vendor_id) }}
                                                </td>
                                                <td class="total d-none d-md-table-cell">
                                                    <a class="text-primary" tooltip="Remove"
                                                        onclick="clearcart('{{ URL::to(@$vendordata->slug . '/cart/clear-' . $cartdata->product_id . '-' . $cartdata->variation_id) }}')"><i
                                                            class="fa-light fa-trash text-danger"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 mb-3">
                        @if (App\Models\SystemAddons::where('unique_identifier', 'subscription')->first() != null &&
                                App\Models\SystemAddons::where('unique_identifier', 'subscription')->first()->activated == 1)
                            @if (App\Models\SystemAddons::where('unique_identifier', 'coupon')->first() != null &&
                                    App\Models\SystemAddons::where('unique_identifier', 'coupon')->first()->activated == 1)

                                @php
                                    $checkplan = App\Models\Transaction::where('vendor_id', @$vendordata->id)
                                        ->orderByDesc('id')
                                        ->first();
                                    $user = App\Models\User::where('id', @$vendordata->id)->first();
                                    if ($user->allow_without_subscription == 1) {
                                        $coupons = 1;
                                    } else {
                                        $coupons = @$checkplan->coupons;
                                    }
                                @endphp
                                @if ($coupons == 1)
                                    <div class="card border-0 mb-3 rounded-0 bg-light promocode">
                                        <div class="card-body">

                                            <div class="row justify-content-between align-items-center mb-md-3 mb-2">

                                                <div class="col-auto d-flex"><label for="promocode"
                                                        class="fs-6 text-dark fw-600 text-truncate">
                                                        </span>{{ trans('labels.apply_promocode') }}</label>
                                                </div>

                                                @if (!session()->get('discount_data'))
                                                    <div class="col-auto"><small><a href="javascript:void(0)"
                                                                class="text-uppercase text-success text-truncate"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#promocodesmodal">{{ trans('labels.select_promocode') }}</a></small>
                                                    </div>
                                                @endif

                                            </div>

                                            <div class="row align-items-center justify-content-between">

                                                @if (session()->get('discount_data'))
                                                    <div class="d-flex">

                                                        <input type="text"
                                                            class="form-control rounded-0 {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'ms-2' : 'me-2' }}"
                                                            value="{{ session()->get('discount_data')['offer_code'] }}"
                                                            id="offer_code"
                                                            placeholder="{{ trans('labels.have_promocode_q') }}" disabled>

                                                        <a href="{{ URL::to(@$vendordata->slug . '/cart/remove-promocode') }}"
                                                            class="btn border-0 rounded-0 btn-fashion">{{ trans('labels.remove') }}</a>

                                                    </div>
                                                @else
                                                    <form
                                                        action="{{ URL::to(@$vendordata->slug . '/cart/apply-promocode') }}"
                                                        method="post">

                                                        @csrf

                                                        <div class="d-flex">

                                                            <input type="hidden" name="subtotal"
                                                                value="{{ $subtotal }}">

                                                            <input type="text"
                                                                class="form-control pb-2 rounded-0 {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'ms-2' : 'me-2' }}"
                                                                name="offer_code" id="offer_code"
                                                                placeholder="{{ trans('labels.have_promocode_q') }}"
                                                                readonly>

                                                            <button type="submit"
                                                                class="btn btn-fashion">{{ trans('labels.apply') }}</button>

                                                        </div>

                                                        @error('offer_code')
                                                            <span class="text-danger">{{ $message }}</span>
                                                        @enderror

                                                    </form>
                                                @endif

                                            </div>

                                        </div>
                                    </div>
                                @endif
                            @endif
                        @else
                            @if (App\Models\SystemAddons::where('unique_identifier', 'coupon')->first() != null &&
                                    App\Models\SystemAddons::where('unique_identifier', 'coupon')->first()->activated == 1)
                                <div class="card border-0 mb-3 rounded-0 bg-light">
                                    <div class="card-body">

                                        <div class="row justify-content-between align-items-center mb-3">

                                            <div class="col-auto"><label for="promocode"
                                                    class="fs-6 text-dark fw-600">{{ trans('labels.apply_promocode') }}</label>
                                            </div>

                                            @if (!session()->get('discount_data'))
                                                <div class="col-auto"><small><a href="javascript:void(0)"
                                                            class="text-uppercase text-success" data-bs-toggle="modal"
                                                            data-bs-target="#promocodesmodal">{{ trans('labels.select_promocode') }}</a></small>
                                                </div>
                                            @endif

                                        </div>

                                        <div class="row align-items-center justify-content-between">

                                            @if (session()->get('discount_data'))
                                                <div class="d-flex">

                                                    <input type="text"
                                                        class="form-control {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'rounded-end rounded-start-0' : 'rounded-end-0 rounded-start' }}"
                                                        value="{{ session()->get('discount_data')['offer_code'] }}"
                                                        id="offer_code"
                                                        placeholder="{{ trans('labels.have_promocode_q') }}" disabled>

                                                    <a href="{{ URL::to(@$vendordata->slug . '/cart/remove-promocode') }}"
                                                        class="btn btn-secondary border-0 {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'rounded-end-0 rounded-start' : 'rounded-end rounded-start-0' }}">{{ trans('labels.remove') }}</a>

                                                </div>
                                            @else
                                                <form action="{{ URL::to(@$vendordata->slug . '/cart/apply-promocode') }}"
                                                    method="post">

                                                    @csrf

                                                    <div class="d-flex">

                                                        <input type="hidden" name="subtotal"
                                                            value="{{ $subtotal }}">

                                                        <input type="text"
                                                            class="form-control pb-2 {{ session()->get('direction') == 2 ? 'rounded-end rounded-start-0' : 'rounded-end-0 rounded-start' }}"
                                                            name="offer_code" id="offer_code"
                                                            placeholder="{{ trans('labels.have_promocode_q') }}" readonly>

                                                        <button type="submit"
                                                            class="btn btn-primary border-0 {{ session()->get('direction') == 2 ? 'rounded-end-0 rounded-start' : 'rounded-end rounded-start-0' }}">{{ trans('labels.apply') }}</button>

                                                    </div>

                                                    @error('offer_code')
                                                        <span class="text-danger">{{ $message }}</span>
                                                    @enderror

                                                </form>
                                            @endif

                                        </div>

                                    </div>
                                </div>
                            @endif
                        @endif
                        <div class="card border-0 mb-3 rounded-0 bg-light">

                            <div class="card-body">

                                <p class="fs-5 text-dark fw-600 border-bottom">{{ trans('labels.summary') }}</p>

                                <ul class="list-group">

                                    @php
                                        
                                        $discount_amount = 0;
                                        
                                        if (session()->has('discount_data')) {
                                            $discount_amount = session()->get('discount_data')['offer_amount'];
                                        }
                                        
                                        $grandtotal = $subtotal - $discount_amount + $totaltax;
                                        
                                    @endphp

                                    <li
                                        class="list-group-item d-flex bg-light px-0 border-0 align-items-center justify-content-between">

                                        <span>{{ trans('labels.sub_total') }}</span>

                                        <span>{{ helper::currency_formate($subtotal, @$vendordata->id) }}</span>

                                    </li>

                                    @if (session()->has('discount_data'))
                                        <li
                                            class="list-group-item d-flex bg-light px-0 border-0 align-items-center justify-content-between">

                                            <span>{{ trans('labels.discount') }}
                                                {{ '(' . session()->get('discount_data')['offer_code'] . ')' }} </span>

                                            <span class="text-danger">-
                                                {{ helper::currency_formate($discount_amount, @$vendordata->id) }}</span>

                                        </li>
                                    @endif

                                    <li
                                        class="list-group-item d-flex bg-light px-0 border-0 align-items-center justify-content-between">

                                        <span>{{ trans('labels.tax') }}</span>

                                        <span>{{ helper::currency_formate($totaltax, @$vendordata->id) }}</span>
                                    </li>
                                    <li class="list-group-item d-flex bg-light px-0 border-0 border-top-dashed align-items-center justify-content-between">
                                        <strong
                                            class="text-success fw-semibold">{{ trans('labels.grand_total') }}</strong>
                                        <strong
                                            class="text-success fw-semibold">{{ helper::currency_formate($grandtotal, @$vendordata->id) }}</strong>
                                    </li>
                                </ul>
                                @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                                        App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                                    @if (helper::appdata(@$vendordata->id)->checkout_login_required == 1 && (!@Auth::user() && !@Auth::user()->type == 3))
                                        <button type="button" class="btn btn-fashion w-100 mt-3" data-bs-toggle="modal"
                                            data-bs-target="#loginmodel">
                                            {{ trans('labels.go_to_checkout') }}
                                        </button>
                                    @else
                                        <a class="btn btn-lg btn-outline-secondary w-100 mt-3 rounded-0 fs-6 text-capitalize"
                                            href="{{ URL::to(@$vendordata->slug . '/checkout') }}"><span>{{ trans('labels.go_to_checkout') }}</span></a>
                                    @endif
                                @else
                                    <a class="btn btn-lg btn-outline-secondary w-100 mt-3 rounded-0 fs-6 text-capitalize"
                                            href="{{ URL::to(@$vendordata->slug . '/checkout') }}"><span>{{ trans('labels.go_to_checkout') }}</span></a>
                                @endif
                                <a class="btn btn-primary rounded-0 py-2 w-100 mt-3"
                                    href="{{ URL::to(@$vendordata->slug . '/') }}"><span>{{ trans('labels.back_top_shop') }}</span></a>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                @include('web.nodata')
            @endif

        </div>

    </section>

    <!-- CART AREA END -->

    <!-- MODAL-PROMOCOE---START -->

    <div class="modal fade" id="promocodesmodal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">

        <div class="modal-dialog modal-dialog-centered">

            <div class="modal-content p-2 rounded-0">

                <div class="modal-body py-0 px-0">

                    <div class="modal-header justify-content-between align-items-center mb-3">
                        <h2 class="text-start text-dark fw-medium fs-4" id="exampleModalLabel">
                            {{ trans('labels.apply_promocode') }}</h2>
                        <button type="button" class="btn_close btn shadow" data-bs-dismiss="modal" aria-label="Close">
                            <i class="fa-solid fa-xmark text-dark"></i>
                        </button>
                    </div>

                    @forelse ($getpromocodelist as $promocode)
                        <div class="card bg-light m-3 border-0">

                            <div class="card-body p-3">

                                <div class="bg-light rounded d-flex justify-content-between align-items-center">

                                    <div>

                                        <h5 class="text-dark">{{ $promocode->offer_name }}</h5>

                                        <p class="mb-0 fw-600 fs-7"> {{ trans('labels.promocode') }} : <span
                                                class="fw-normal text-decoration-underline text-uppercase text-secondary">{{ $promocode->offer_code }}</span>
                                        </p>

                                    </div>

                                    <div class="d-grid text-center">

                                        <span>{{ $promocode->offer_type == 1 ? Helper::currency_formate($promocode->offer_amount, @$vendordata->id) : $promocode->offer_amount . '%' }}</span>

                                        <button class="btn btn-sm btn-outline-secondary btn-block rounded-0 mt-1"
                                            onclick="$('#offer_code').val('{{ $promocode->offer_code }}')"
                                            data-bs-dismiss="modal">{{ trans('labels.copy') }}</button>

                                    </div>

                                </div>

                            </div>

                        </div>

                    @empty

                        @include('web.nodata')
                    @endforelse

                </div>

            </div>

        </div>

    </div>

    <!-- MODAL-PROMOCOE---END -->

    <!-- Login Model Start -->
    @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
            App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
        @if (helper::appdata(@$vendordata->id)->checkout_login_required == 1)
            <div class="modal fade" id="loginmodel" tabindex="-1" aria-labelledby="loginmodelLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content p-2 rounded-0">
                        <div class="modal-header justify-content-between align-items-center">
                            <h2 class="text-start mb-2 text-dark fw-medium fs-4">Checkout as Guest</h2>
                            <button type="button" class="btn_close btn shadow" data-bs-dismiss="modal"
                                aria-label="Close">
                                <i class="fa-solid fa-xmark text-dark"></i>
                            </button>
                        </div>

                        <div class="modal-body text-center">
                            <p class="text-start mb-3 fs-7 text-dark">Don't have an account? Don't worry! You can complete
                                your
                                checkout process as a guest & choose to create an account later</p>

                        </div>
                        <div class="modal-footer">
                            <div class="d-md-flex justify-content-between align-items-center w-100">

                                <a href="{{ URL::to(@$vendordata->slug . '/login') }}"
                                    class="btn btn-fashion-outline w-100">{{ trans('labels.login_with_your_account') }}</a>

                                <a href="{{ URL::to(@$vendordata->slug . '/checkout') }}"
                                    class="btn btn-fashion w-100 mt-4 mt-md-0 {{ session()->get('direction') == 2 ? 'me-md-4' : 'ms-md-4' }}">{{ trans('labels.continue_as_guest') }}</a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endif
    <!-- Login Model End -->
@endsection

@section('scripts')
    <script>
        var is_logedin = "{{ @Auth::user()->type == 3 ? 1 : 2 }}";
        var checkouturl = "{{ URL::to(@$vendordata->slug . '/checkout') }}";
    </script>

    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/cart.js') }}"></script>
@endsection
