<!doctype html>
<html lang="en" dir="{{ session()->get('direction') == 2 ? 'rtl' : 'ltr' }}">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta property="og:title" content="{{ @helper::appdata(@$vendordata->id)->meta_title }}" />
    <meta property="og:description" content="{{ @helper::appdata(@$vendordata->id)->meta_description }}" />
    <meta property="og:image" content='{{ helper::image_path(@helper::appdata(@$vendordata->id)->og_image) }}' />
    <title>{{ @helper::appdata(@$vendordata->id)->web_title }}</title>
    <link rel="stylesheet"
        href="{{ url(env('ASSETPATHURL') . 'web-assets/css/magnific_popup/magnific-popup.min.css') }}">
    <!-- magnific-popup -->
    <link rel="shortcut icon" href="{{ helper::image_path(helper::appdata(@$vendordata->id)->favicon) }}"
        type="image/x-icon"><!-- FAVICON ICON -->
    <link rel="stylesheet" href="{{ url(env('ASSETPATHURL') . 'web-assets/css/bootstrap/bootstrap.min.css') }}" />
    <!-- BOOTSTRAP CSS -->
    <link rel="stylesheet" href="{{ url(env('ASSETPATHURL') . 'web-assets/css/fontawesome/all.min.css') }}" />
    <!-- FONTAWESOME CSS -->
    <link rel="stylesheet"
        href="{{ url(env('ASSETPATHURL') . 'web-assets/css/owl_carousel/owl.theme.default.min.css') }}" />
    <link rel="stylesheet"
        href="{{ url(env('ASSETPATHURL') . 'web-assets/css/owl_carousel/owl.carousel.min.css') }}" />
    <!-- OWL CAROUSEL CSS -->
    <link rel="stylesheet" href="{{ url(env('ASSETPATHURL') . 'web-assets/css/jquery_ui/jquery-ui.min.css') }}" />

    <link rel="stylesheet" href="{{ url(env('ASSETPATHURL') . 'web-assets/css/sweetalert/sweetalert2.min.css') }}" />

    <!-- OWL CAROUSEL CSS animation -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <!-- SWEETALERT CSS -->
    {{-- datatable css --}}
    <link rel="stylesheet"
        href="{{ url(env('ASSETPATHURL') . 'admin-assets/css/datatables/dataTables.bootstrap5.min.css') }}">

    <link rel="stylesheet"
        href="{{ url(env('ASSETPATHURL') . 'admin-assets/css/datatables/buttons.dataTables.min.css') }}">
    {{-- datatable css --}}
    <!-- Image zoom CSS -->
    <link rel="stylesheet" href="{{ url(env('ASSETPATHURL') . 'web-assets/css/style.css') }}" /><!-- CUSTOM CSS -->
    <link rel="stylesheet" href="{{ url(env('ASSETPATHURL') . 'web-assets/css/responsive.css') }}" />
    <!-- RESPONSIVE CSS -->
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <!-- PWA  -->
    @if (App\Models\SystemAddons::where('unique_identifier', 'subscription')->first() != null &&
            App\Models\SystemAddons::where('unique_identifier', 'subscription')->first()->activated == 1)
        @if (App\Models\SystemAddons::where('unique_identifier', 'pwa')->first() != null &&
                App\Models\SystemAddons::where('unique_identifier', 'pwa')->first()->activated == 1)
            @php
                $checkplan = App\Models\Transaction::where('vendor_id', $vendordata->id)
                    ->orderByDesc('id')
                    ->first();
                $user = App\Models\User::where('id', $vendordata->id)->first();
                if ($user->allow_without_subscription == 1) {
                    $pwa = 1;
                } else {
                    $pwa = @$checkplan->pwa;
                }
            @endphp
            @if ($pwa == 1)
                @if (helper::appdata($vendordata->id)->pwa == 1)
                    @include('web.pwa.pwa')
                @endif
            @endif
        @else
            @if (App\Models\SystemAddons::where('unique_identifier', 'pwa')->first() != null &&
                    App\Models\SystemAddons::where('unique_identifier', 'pwa')->first()->activated == 1)
                @if (helper::appdata($vendordata->id)->pwa == 1)
                    @include('web.pwa.pwa')
                @endif
            @endif
        @endif
    @endif
    @if (App\Models\SystemAddons::where('unique_identifier', 'subscription')->first() != null &&
            App\Models\SystemAddons::where('unique_identifier', 'subscription')->first()->activated == 1)
        @if (App\Models\SystemAddons::where('unique_identifier', 'pixel')->first() != null &&
                App\Models\SystemAddons::where('unique_identifier', 'pixel')->first()->activated == 1)
            @php
                $checkplan = App\Models\Transaction::where('vendor_id', $vendordata->id)
                    ->orderByDesc('id')
                    ->first();
                $user = App\Models\User::where('id', $vendordata->id)->first();
                if ($user->allow_without_subscription == 1) {
                    $pixel = 1;
                } else {
                    $pixel = @$checkplan->pixel;
                }
            @endphp
            @if ($pixel == 1)
                @include('web.pixel.pixel')
            @endif

        @endif
    @else
        @if (App\Models\SystemAddons::where('unique_identifier', 'pixel')->first() != null &&
                App\Models\SystemAddons::where('unique_identifier', 'pixel')->first()->activated == 1)
            @include('web.pixel.pixel')
        @endif
    @endif
    <style>
        :root {
            --bs-primary: {{ @helper::appdata(@$vendordata->id)->primary_color }};
            --bs-secondary: {{ @helper::appdata(@$vendordata->id)->secondary_color }};
            --bs-primary-rgb: 22, 22, 46;
            --bs-secondary-rgb: {{ @helper::appdata($vendordata->id)->secondary_color . '10' }};
        }

        /**/
    </style>
    @yield('styles')
</head>

<body>
    <!-- BACK TO TOP BUTTON START -->
    <section id="back-to-top" class="show">
        <a class="text-dark">
            <i class="fa-solid fa-angle-up"></i>
        </a>
    </section>
    <!-- BACK TO TOP BUTTON END -->

    <!-- pre-loader section -->
    <div id="loader-wrapper">
        <div id="loader">
        </div>

        <div class="loader-section section-left"></div>
        <div class="loader-section section-right"></div>

    </div>

    <!-- pre-loader section -->
    <main>
        @include('web.layout.common_header')
        <!-- FOR SMALL DEVICES -->
        <div class="offcanvas offcanvas-width mobile-main-sidebar {{ session()->get('direction') == 2 ? 'offcanvas-start' : 'offcanvas-end' }}"
            tabindex="-1" id="common-slidebar" aria-labelledby="offcanvasRightLabel">

            <div class="offcanvas-header">
                <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>

            <div class="offcanvas-body">
                <ul class="slider-menu">
                    <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/') }}"
                            class="slider-link {{ request()->is($vendordata->slug . '/') ? 'mb-active' : '' }}">{{ trans('labels.home') }}</a>
                    </li>
                    <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/shop_all') }}"
                            class="slider-link {{ request()->is($vendordata->slug . '/shop_all') ? 'mb-active' : '' }}">{{ trans('labels.shop_all') }}</a>
                    </li>
                    <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/categories') }}"
                            class="slider-link {{ request()->is($vendordata->slug . '/categories') ? 'mb-active' : '' }}">{{ trans('labels.categories') }}</a>
                    </li>
                    <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/gallery') }}"
                            class="slider-link {{ request()->is($vendordata->slug . '/gallery') ? 'mb-active' : '' }}">{{ trans('labels.gallery') }}</a>
                    </li>
                    @if (App\Models\SystemAddons::where('unique_identifier', 'subscription')->first() != null &&
                            App\Models\SystemAddons::where('unique_identifier', 'subscription')->first()->activated == 1)
                        @if (App\Models\SystemAddons::where('unique_identifier', 'blog')->first() != null &&
                                App\Models\SystemAddons::where('unique_identifier', 'blog')->first()->activated == 1)
                            @php
                                $checkplan = App\Models\Transaction::where('vendor_id', $vendordata->id)
                                    ->orderByDesc('id')
                                    ->first();
                                $user = App\Models\User::where('id', $vendordata->id)->first();
                                if ($user->allow_without_subscription == 1) {
                                    $blogs = 1;
                                } else {
                                    $blogs = @$checkplan->blogs;
                                }
                            @endphp
                            @if ($blogs == 1)
                                <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/blogs') }}"
                                        class="slider-link {{ request()->is($vendordata->slug . '/blogs') ? 'mb-active' : '' }}">{{ trans('labels.blog') }}</a>
                                </li>
                            @endif
                        @endif
                    @else
                        @if (App\Models\SystemAddons::where('unique_identifier', 'blog')->first() != null &&
                                App\Models\SystemAddons::where('unique_identifier', 'blog')->first()->activated == 1)
                            <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/blogs') }}"
                                    class="slider-link {{ request()->is($vendordata->slug . '/blogs') ? 'mb-active' : '' }}">{{ trans('labels.blog') }}</a>
                            </li>
                        @endif
                    @endif

                    <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/contact-us') }}"
                            class="slider-link {{ request()->is($vendordata->slug . '/contact-us') ? 'mb-active' : '' }}">{{ trans('labels.help_contact') }}</a>
                    </li>
                    <li class="border-bottom"><a href="{{ URL::to(@$vendordata->slug . '/find-order') }}"
                            class="slider-link {{ request()->is($vendordata->slug . '/find-order') ? 'mb-active' : '' }}">{{ trans('labels.find_my_order') }}</a>
                    </li>

                </ul>
            </div>
        </div>
        <!-- FOR SMALL DEVICES -->

        <!-- NAVBAR AREA END -->
        @yield('contents')

        @include('web.layout.footer')
        <input type="hidden" name="currency" id="currency"
            value="{{ @helper::appdata(@$vendordata->id)->currency }}">
        <input type="hidden" name="currency_position" id="currency_position"
            value="{{ @helper::appdata(@$vendordata->id)->currency_position }}">
    </main>

    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/jquery/jquery.min.js') }}"></script><!-- JQUERY JS -->
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/jquery_ui/jquery-ui.min.js') }}"></script><!-- JQUERY UI JS -->
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/bootstrap/bootstrap.bundle.min.js') }}"></script><!-- BOOTSTRAP JS -->
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/owl_carousel/owl.carousel.js') }}"></script><!-- OWL CAROUSEL JS -->
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/sweetalert/sweetalert2.min.js') }}"></script><!-- SWEETALERT JS -->
    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/jquery.dataTables.min.js') }}"></script><!-- Datatables JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/dataTables.bootstrap5.min.js') }}"></script><!-- Datatables Bootstrap5 JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/dataTables.buttons.min.js') }}"></script><!-- Datatables Buttons JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/jszip.min.js') }}"></script><!-- Datatables Excel Buttons JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/pdfmake.min.js') }}"></script><!-- Datatables Make PDF Buttons JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/vfs_fonts.js') }}"></script><!-- Datatables Export PDF Buttons JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'admin-assets/js/datatables/buttons.html5.min.js') }}"></script><!-- Datatables Buttons HTML5 JS -->

    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/magnific_popup/jquery.magnific-popup.min.js') }}"></script><!-- Magnific Popup core JS file -->
    <script>
        // Magnific-popup for ZOOM after click current image
        $(".gallery .images__link").magnificPopup({
            type: "image",
            gallery: {
                enabled: true,
                tCounter: "%curr% of %total%"
            },
            removalDelay: 300,
            mainClass: "mfp-fade"
        });

        // Modify checked preview
        $(".gallery .preview__link").on("click", function() {
            $(".gallery .preview__link").removeClass("checked");
            $(this).addClass("checked");
        });
    </script>
    <script>
        // Modify checked preview
        $("#preview__link").on("click", function() {
            $(".modal-preview .preview__link").removeClass("checked");
            $(this).addClass("checked");
        });
    </script>
    <script>
        let rtl = "{{ session()->get('direction') == 2 ? '2' : '1' }}";
        let are_you_sure = "{{ trans('messages.are_you_sure') }}";
        let yes = "{{ trans('messages.yes') }}";
        let no = "{{ trans('messages.no') }}";
        let wrong = "{{ trans('messages.wrong') }}";
        var formate = "{{ helper::appdata($vendordata->id)->currency_formate }}";

        // top deals parameter
        var start_date = "{{ @$topdeals->start_date }}";
        var start_time = "{{ @$topdeals->start_time }}";
        var end_date = "{{ @$topdeals->end_date }}";
        var end_time = "{{ @$topdeals->end_time }}";
        var topdeals = "{{ !empty($topdealsproducts) ? 1 : 0 }}";
        var time_zone = "{{ helper::appdata($vendordata->id)->timezone }}";
        // top deals parameter
    </script>

    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/customsweetalert.js') }}"></script><!-- CUSTOM JS -->
    <script>
        @if (Session::has('success'))
            showtoast('success', "{{ session('success') }}");
        @endif
        @if (Session::has('error'))
            showtoast('error', "{{ session('error') }}");
        @endif
    </script>
    <script>
        var is_logedin = "{{ @Auth::user()->type == 3 ? 1 : 2 }}";
        loginurl = "{{ URL::to($vendordata->slug . '/login') }}";
    </script>
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/custom.js') }}"></script><!-- CUSTOM JS -->

    <!-- Google tag (gtag.js) -->

    <script async src="https://www.googletagmanager.com/gtag/js?id={{ helper::appdata(1)->tracking_id }}"></script>


    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', '{{ helper::appdata(1)->tracking_id }}');
    </script>
    @if (App\Models\SystemAddons::where('unique_identifier', 'subscription')->first() != null &&
            App\Models\SystemAddons::where('unique_identifier', 'subscription')->first()->activated == 1)
        @if (App\Models\SystemAddons::where('unique_identifier', 'pwa')->first() != null &&
                App\Models\SystemAddons::where('unique_identifier', 'pwa')->first()->activated == 1)
            @php
                $checkplan = App\Models\Transaction::where('vendor_id', $vendordata->id)
                    ->orderByDesc('id')
                    ->first();
                $user = App\Models\User::where('id', $vendordata->id)->first();
                if ($user->allow_without_subscription == 1) {
                    $pwa = 1;
                } else {
                    $pwa = @$checkplan->pwa;
                }
            @endphp
            @if ($pwa == 1)
                <script src="{{ url('storage/app/public/sw.js') }}"></script>
                <script>
                    if (!navigator.serviceWorker.controller) {
                        navigator.serviceWorker.register("{{ url('storage/app/public/sw.js') }}").then(function(reg) {
                            console.log("Service worker has been registered for scope: " + reg.scope);
                        });
                    }
                </script>
            @endif
        @endif
    @else
        @if (App\Models\SystemAddons::where('unique_identifier', 'pwa')->first() != null &&
                App\Models\SystemAddons::where('unique_identifier', 'pwa')->first()->activated == 1)
            <script src="{{ url('storage/app/public/sw.js') }}"></script>
            <script>
                if (!navigator.serviceWorker.controller) {
                    navigator.serviceWorker.register("{{ url('storage/app/public/sw.js') }}").then(function(reg) {
                        console.log("Service worker has been registered for scope: " + reg.scope);
                    });
                }
            </script>
        @endif
    @endif

    <script>
        let deferredPrompt = null;
        window.addEventListener('beforeinstallprompt', (e) => {
            $('.mobile_drop_down').show();
            deferredPrompt = e;
        });
        const mobile_install_app = document.getElementById('mobile-install-app');
        if (mobile_install_app != null) {
            mobile_install_app.addEventListener('click', async () => {
                if (deferredPrompt !== null) {
                    deferredPrompt.prompt();
                    const {
                        outcome
                    } = await deferredPrompt.userChoice;
                    if (outcome === 'accepted') {
                        deferredPrompt = null;
                    }
                }
            });
        }
        $('.nav02').click(function() {
            $('.mobile_drop_down').animate({
                bottom: "-100vh"
            }, 200);
        });

        $(document).ready(function() {
            window.addEventListener('beforeinstallprompt', (e) => {
                $('.install-app-btn-container').show();
                $('.mobile_drop_down').animate({
                    bottom: "0px"
                }, 200);
                deferredPrompt = e;
            });
        });
    </script>
    <script>
        var nexturl = "{{ URL::to($vendordata->slug . '/getproductdata') }}";
        var ratting = "{{ number_format(0, 1) }}";
        var totalratting = "{{ trans('labels.ratting') }}";
        var carturl = "{{ URL::to(@$vendordata->slug . '/cart/add') }}";
        var fullviewurl = "{{ URL::to(@$vendordata->slug . '/products/') }}";
        var reviewshow = 0;
        if ("{{App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()}}" != null) {
            if ("{{helper::appdata($vendordata->id)->checkout_login_required}}" == 1) {
                reviewshow = 1;
            }
        }
    </script>

    <script>
        function productview(id) {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: nexturl,
                method: "get",
                data: {
                    id: id,
                },
                success: function(response) {
                    $('.product-title').html(response.productdata.name);
                    $('#modal_additional_tax').html(response.productdata.tax);
                    $('#modal_product_price').html(currency_formate(response.productdata.price));
                    $('#modal_product-original-price').html(currency_formate(response.productdata
                        .original_price));
                    var off = 100 - (response.productdata.price * 100) / (response.productdata.original_price);
                    if (off > 0) {
                        $("#modal_price-off").show().html('-'+off.toFixed(formate) + "%" + " " + "OFF");
                    }
                    $('.line-5').html(response.productdata.description);
                    if (reviewshow == 1) {
                        if (response.productdata.ratings_average == null || response.productdata
                            .ratings_average ==
                            "") {
                            $('.average_rating').html(ratting);
                        } else {
                            $('.average_rating').html(response.productdata.ratings_average);
                        }
                        $('.total-ratting').html('(' + response.totalratting + ' ' + (totalratting) + ')');
                    }

                    let html = '';
                    var e;
                    let html1 = '';
                    let variation = '';
                    let multiplevariants = '';
                    var click = "";
                    var attribute;
                    var active = "";
                    var tax_amount = (response.productdata.price * response.productdata.tax) / 100;
                    if (response.productdata.multi_image.length > 0) {
                        for (var i = 0; i < response.productdata.multi_image.length; i++) {
                            if (i == 0) {
                                active = "active";
                            } else {
                                active = "";
                            }
                            console.log(active);
                            html1 += "<div class='carousel-item " + ' ' + active + " ' name='image" + [i] +
                                "'><img class='img-fluid w-100' src=" + response.productdata.multi_image[
                                    i].image_url + "></div>";
                        }
                    } else {
                        html1 += "<div class='carousel-item " + ' ' + active + "' name='image" + [i] +
                            "'><img class='img-fluid w-100' src=" + response.productdata.product_image
                            .image_url + "></div>";

                    }
                    $('#carouseltest .carousel-inner').html(html1 +
                        "<button class='carousel-control-prev' type='button' data-bs-target='#carouseltest' data-bs-slide='prev'><span class='carousel-control-prev-icon' aria-hidden='true'><i class='fa-light fa-angle-left'></i></span></button><button class='carousel-control-next' type='button' data-bs-target='#carouseltest' data-bs-slide='next'><span class='carousel-control-next-icon' aria-hidden='true'><i class='fa-light fa-angle-right'></i></span></button>"
                    );
                    if (response.productdata.has_variation == 1) {
                        variation += "<p class='text-primary me-2'>" + response.productdata.attribute + "</p>";
                        variation += ": <span class='text-dark fw-600'>" + response.productdata.multi_variation[
                            0].name + "</span>";
                        for (var i = 0; i < response.productdata.multi_variation.length; i++) {
                            if (i == 0) {
                                click = "checked";
                            } else {
                                click = '';
                            }
                            $('.modal-product-variation').removeClass('d-none');
                            multiplevariants += "<li class='variations'> <input " + click +
                                " type='radio' id='size" +
                                i +
                                "' name='modal_size' value='' class='d-none' onclick='getprice(this.id)' data-price='" +
                                response.productdata
                                .multi_variation[i].price + "' data-original-price='" + response.productdata
                                .multi_variation[i].original_price + "' data-variationname='" + response
                                .productdata.attribute + "' data-name='" + response.productdata
                                .multi_variation[i].name + "' data-id='" + response.productdata
                                .multi_variation[i].id + "'> <label for='size" + i + "'>" + response
                                .productdata.multi_variation[i].name + "</label></li>";
                            $('.variation').removeClass('d-none');
                        }

                    } else {
                        variation = '';
                        multiplevariants = '';
                        $('.modal-product-variation').addClass('d-none');
                        $('.variation').addClass('d-none');
                    }
                    $('.multivariants').html(multiplevariants);
                    $('.variation').html(variation);
                    if (response.productdata.attribute == "" || response.productdata.attribute == null) {
                        attribute = null;
                    } else {
                        attribute = response.productdata.attribute;
                    }
                    $('#modal-addtocart').attr('onClick', 'addtocart("' + response.productdata.id + '","' +
                        response.productdata.slug + '","' + response.productdata.name + '","' + response
                        .productdata.product_image.image + '","' + tax_amount + '","' + response.productdata
                        .price + '","' + attribute + '","' + carturl + '");');
                    $('#full_view').attr('href', fullviewurl + '/' + response.productdata.slug);
                    $('#pro-view').modal('show');
                },
                error: function(data) {
                    return false;
                }
            });

        }
    </script>
    <script>
        function getprice(id) {
            let variation = '';
            $("#modal_product_price").html(currency_formate($('#' + id).data('price')));

            if ($('#' + id).data('original-price') > 0) {
                $("#modal_product-original-price").html(currency_formate($('#' + id).data('original-price')));

                $(".product-price-off-box").show();

                var off = 100 - $('#' + id).data('price') * 100 / $('#' + id).data('original-price');
                $('.product-variation').removeClass('d-none');
                variation += "<p class='text-primary me-2'>" + $('#' + id).data('variationname') + "</p>";
                variation += ": <span class='text-dark fw-600'>" + $('#' + id).data('name') + "</span>";
                $("#modal_price-off").show().html(off.toFixed(formate) + "%" + " " + "OFF");
                $('.variation').html(variation);
            } else {
                $("#modal_product-original-price").html("");

                $(".product-price-off-box").hide();
            }
        }
    </script>
    {{--  top deals modal view --}}
    <script>
        function topdelasproductview(id) {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: nexturl,
                method: "get",
                data: {
                    id: id,
                },
                success: function(response) {

                    if ("{{ @helper::top_deals($vendordata->id)->offer_type }}" == 1) {
                        var price = response.productdata.price -
                            "{{ @helper::top_deals($vendordata->id)->offer_amount }}";
                    } else {
                        var price = response.productdata.price - response.productdata.price * (
                            "{{ @helper::top_deals($vendordata->id)->offer_amount }}" / 100);
                    }
                    var original_price = response.productdata.price;
                    console.log(response);
                    $('.product-title').html(response.productdata.name);
                    $('#modal_additional_tax').html(response.productdata.tax);
                    $('#modal_product_price').html(currency_formate(price));
                    $('#modal_product-original-price').html(currency_formate(original_price));
                    var off = 100 - (price * 100) / (original_price);
                    if (off > 0) {
                        $("#modal_price-off").show().html('-'+off.toFixed(formate) + "%" + " " + "OFF");
                    }
                    $('.line-5').html(response.productdata.description);
                    if (reviewshow == 1) {
                        if (response.productdata.ratings_average == null || response.productdata.ratings_average == "") {
                        $('.average_rating').html(ratting);
                    } else {
                        $('.average_rating').html(response.productdata.ratings_average);
                    }
                    $('.total-ratting').html('(' + response.totalratting + ' ' + (totalratting) + ')');
                    }
                   
                    let html = '';
                    var e;
                    let html1 = '';
                    let variation = '';
                    let multiplevariants = '';
                    var click = "";
                    var attribute;
                    var active = "";
                    var tax_amount = (price * response.productdata.tax) / 100;
                    if (response.productdata.multi_image.length > 0) {
                        for (var i = 0; i < response.productdata.multi_image.length; i++) {
                            if (i == 0) {
                                active = "active";
                            } else {
                                active = "";
                            }
                            console.log(active);
                            html1 += "<div class='carousel-item " + ' ' + active + " ' name='image" + [i] +
                                "'><img class='img-fluid w-100' src=" + response.productdata.multi_image[
                                    i].image_url + "></div>";
                        }
                    } else {
                        html1 += "<div class='carousel-item " + ' ' + active + "' name='image" + [i] +
                            "'><img class='img-fluid w-100' src=" + response.productdata.product_image
                            .image_url + "></div>";

                    }
                    $('#carouseltest .carousel-inner').html(html1 +
                        "<button class='carousel-control-prev' type='button' data-bs-target='#carouseltest' data-bs-slide='prev'><span class='carousel-control-prev-icon' aria-hidden='true'><i class='fa-light fa-angle-left'></i></span></button><button class='carousel-control-next' type='button' data-bs-target='#carouseltest' data-bs-slide='next'><span class='carousel-control-next-icon' aria-hidden='true'><i class='fa-light fa-angle-right'></i></span></button>"
                    );
                    console.log(response.productdata.multi_variation[i]);
                    if (response.productdata.has_variation == 1) {
                        variation += "<p class='text-primary me-2'>" + response.productdata.attribute + "</p>";
                        variation += ": <span class='text-dark fw-600'>" + response.productdata.multi_variation[
                            0].name + "</span>";

                        for (var i = 0; i < response.productdata.multi_variation.length; i++) {
                            if (i == 0) {
                                click = "checked";
                            } else {
                                click = '';
                            }
                            if ("{{ @helper::top_deals($vendordata->id)->offer_type }}" == 1) {
                                var variation_price = response.productdata.multi_variation[i].price -
                                    "{{ @helper::top_deals($vendordata->id)->offer_amount }}";
                            } else {
                                var variation_price = response.productdata.multi_variation[i].price - response
                                    .productdata.multi_variation[i].price * (
                                        "{{ @helper::top_deals($vendordata->id)->offer_amount }}" / 100);
                            }
                            var variation_original_price = response.productdata.multi_variation[i].price;
                            $('.modal-product-variation').removeClass('d-none');
                            multiplevariants += "<li class='variations'> <input " + click +
                                " type='radio' id='size" +
                                i +
                                "' name='modal_size' value='' class='d-none' onclick='getprice(this.id)' data-price='" +
                                variation_price + "' data-original-price='" + variation_original_price +
                                "' data-variationname='" + response
                                .productdata.attribute + "' data-name='" + response.productdata
                                .multi_variation[i].name + "' data-id='" + response.productdata
                                .multi_variation[i].id + "'> <label for='size" + i + "'>" + response
                                .productdata.multi_variation[i].name + "</label></li>";
                            $('.variation').removeClass('d-none');
                        }

                    } else {
                        variation = '';
                        multiplevariants = '';
                        $('.modal-product-variation').addClass('d-none');
                        $('.variation').addClass('d-none');
                    }
                    $('.multivariants').html(multiplevariants);
                    $('.variation').html(variation);
                    if (response.productdata.attribute == "" || response.productdata.attribute == null) {
                        attribute = null;
                    } else {
                        attribute = response.productdata.attribute;
                    }
                    $('#modal-addtocart').attr('onClick', 'addtocart("' + response.productdata.id + '","' +
                        response.productdata.slug + '","' + response.productdata.name + '","' + response
                        .productdata.product_image.image + '","' + tax_amount + '","' + response.productdata
                        .price + '","' + attribute + '","' + carturl + '");');
                    $('#full_view').attr('href', fullviewurl + '/' + response.productdata.slug);
                    $('#pro-view').modal('show');
                },
                error: function(data) {
                    return false;
                }
            });

        }

        function topdealsprice(id) {
            let variation = '';

            $("#modal_product_price").html(currency_formate($('#' + id).data('price')));

            if ($('#' + id).data('original-price') > 0) {
                $("#modal_product-original-price").html(currency_formate($('#' + id).data('original-price')));

                $(".product-price-off-box").show();

                var off = 100 - $('#' + id).data('price') * 100 / $('#' + id).data('original-price');
                $('.product-variation').removeClass('d-none');
                variation += "<p class='text-primary me-2'>" + $('#' + id).data('variationname') + "</p>";
                variation += ": <span class='text-dark fw-600'>" + $('#' + id).data('name') + "</span>";
                $("#modal_price-off").show().html(off.toFixed(formate) + "%" + " " + "OFF");
                $('.variation').html(variation);
            } else {
                $("#modal_product-original-price").html("");

                $(".product-price-off-box").hide();
            }
        }
    </script>
    @yield('scripts')
</body>

</html>
