function cleardata()
{
    $('#additems').modal('hide');
    $('#item_id').val('');
    $('#item_name').val('');
    $('#item_price').val('');
    $('#item_tax').val('');
    $('#item_image').val('');
    $('#orignal_price').val('');
    $('#qty').val('');
    $('#extras').html('');
    $('#variants').html('');
    $('#viewitem_name').html('');
    $('#viewitem_price').html('');
}

 function categories_filter(cat_id,nexturl)
 {
    $('.scroll-list').hasClass('active');
    $('.active').removeClass('active');
    $('#search-keyword').val('');

    if(cat_id == '')
    {
        $("#cat").addClass('active');
    }
    $("#cat-"+cat_id).addClass('active');
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: nexturl,
        method: "get",
        data: {
            id: cat_id 
        },
        success: function (data) {  
            $("#pos-item").html('');
            $("#cat_id").val();
            $("#pos-item").html(data);
        },
        error: function (data) {
            toastr.error(wrong);
            return false;
        }
    });
 }

 $("#plusqty").on("click", function() {
    "use strict";
    $.ajax({
      headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
      },
      url: qtyupdateurl,
      data: {
        item_id: $("#item_id").val(),
        variants_id: $('input[name="variants"]:checked').attr("variants-id"),
        qty: $("#qty").val(),
        variant_qty: $("#checked_product_qty").val()
      },
      method: "POST",
      success: function(response) {
        if (response.status == 0) {
          toastr.error(stock_message);
          $("#qty").val(response.qty);
        } else {
          $("#qty").val(response.qty);
        }
      },
      error: function(e) {
        $("#qty").val(response.qty);
        toastr.error(stock_message);
      }
    });
  });

$('#minusqty').on("click",function(){
    "use strict";
    var qty = parseInt($('#qty').val());
    qty = qty - 1;
    if(qty < 1)
    {
        qty = 1;
    }
    $('#qty').val(qty);
});

$('#search-keyword').keyup(function(){
    "use strict";

    var cat_id = $('#cat_id').val();
    var keyword =  $('#search-keyword').val();
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: $('#search-url').val(),
        method: "get",
        data: {
            id: cat_id,
            keyword : keyword 
        },
        success: function (data) {  
            $("#pos-item").html('');
            $("#cat_id").val();
            $("#pos-item").html(data);
        },
        error: function (data) {
            toastr.error(wrong);
            return false;
        }
    });
});

function addtocart(id,name,price,image,tax,qty,orignal_price,slug,attribute,product_qty) {
 
    var variants_id = $('input[name="variants"]:checked').attr("variants-id");
    var variants_name = $('input[name="variants"]:checked').attr("variants_name");
    var variants_price = $('input[name="variants"]:checked').attr("price");
    var variant_qty = $('input[name="variants"]:checked').attr("qty");

    $('.addbtn-'+id).hide();
    $('.showload-'+id).show();

    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: $('#addtocarturl').val(),
        data: {
            id: id,
            name: name,
            image: image,
            item_price: price,
            price: orignal_price,
            tax: tax,
            variants_id: variants_id,
            variants_name: variants_name,
            variants_price: variants_price,
            slug : slug,
            qty: qty,
            attribute : attribute, 
            variant_qty: variant_qty,
            product_qty: product_qty
            
        },
        method: 'POST', //Post method,
        success: function(response) {
            if(response.status == 0)
            {
                toastr.error(response.message);
                setTimeout(() => {
                    document.location.reload();
                  }, 4000);
               
            }
            else{
                $('.showload-'+id).hide();
                $('.addbtn-'+id).show();
                $('.addactive-'+id).addClass('active');
                $('#additems').modal('hide');
                $("#cartview").html('');
                $("#cartview").html(response);
                toastr.success("Add Success");
                cleardata();
            }
          
        },
        error: function(response) {
            toastr.error(response.message);
        }
    })
};

function calladdtocart()
{
    var id = $('#item_id').val();
    var item_name = $('#item_name').val();
    var item_price = $('#item_price').val();
    var item_qty = $('#qty').val();
    var item_image = $('#item_image').val();
    var tax = $('#item_tax').val();
    var orignal_price = $('#orignal_price').val(); 
    var slug = $('#slug').val(); 
    var attribute = $('#attribute').val(); 
    var variant_qty = $("#checked_product_qty").val();

    addtocart(id,item_name,item_price,item_image,tax,item_qty,orignal_price,slug,attribute,variant_qty);
}

function showitems(id,item_name,item_price,item_image,slug,attribute,qty)
{
    "use strict";
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: $('#showitemurl').val(),
        method: "post",
        data: {
            id: id,
        },
        
        success: function (response) {  
            var e;
            let html = '';
            var count_varient = 0;
         
            let price = parseInt(item_price);
            for(e in response.variation)
            {
            count_varient = parseInt(count_varient + 1);
                if (e == 0) 
                {
                    var checked = "checked";
                }
                else
                {
                    var checked = "";
                }
                $("#checked_product_qty").val( response.variation[0].qty);
                html += '<div><input class="form-check-input" type="radio" '+ checked + ' id="variants'+ response.variation[e].id +'" name="variants" variants-id="'+response.variation[e].id+'" variants_name="'+response.variation[e].name+'" price="'+response.variation[e].price+'" qty="'+response.variation[e].qty +'" onclick="pricechange()"  ><label class="form-check-label mx-1 text-primary fw-500 fs-7 " for="variants'+response.variation[e].id+'">'+ response.variation[e].name +' <span class="px-1 text-muted"> ('+ currency_formate(response.variation[e].price) +') </span></label></div>';
            }

            

            $('#qty').val(1);
            $('#variants').html(html);
            $('#viewitem_name').html(item_name);
            $('#viewitem_price').html(" ("+ currency_formate(item_price) + ")");
        

            if(count_varient == 0)
            {
                $('#variants_title').html('');
            }

            $('#item_id').val(id);
            $('#item_name').val(item_name);
            $('#item_price').val(item_price);
            $('#item_tax').val(response.getproduct.tax);
            $('#item_image').val(item_image);
            $('#orignal_price').val(parseInt(item_price));
            $('#slug').val(slug);
            $('#attribute').val(attribute);
            $('#additems').modal('show');
        },
        error: function (response) {
            toastr.error(wrong);
            return false;
        }
    });
}

var variants = document.getElementsByName('variants');
function pricechange()
{
    var variant_price = $('input[name="variants"]:checked').attr("price");
    var variant_qty = $('input[name="variants"]:checked').attr("qty");
    $('#viewitem_price').html(" ("+ currency_formate(variant_price) + ")");
    $("#checked_product_qty").val(variant_qty);
}

function RemoveCart(cart_id) {
    "use strict";
    const swalWithBootstrapButtons = Swal.mixin({
        customClass: {
            confirmButton: 'btn btn-success mx-1',
            cancelButton: 'btn btn-danger bg-danger mx-1'
        },
        buttonsStyling: false
    })
    swalWithBootstrapButtons.fire({
        icon: 'error',
        title: title,
        showCancelButton: true,
        allowOutsideClick: false,
        allowEscapeKey: false,
        confirmButtonText: yes,
        cancelButtonText: no,
        reverseButtons: true,
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve, reject) {
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: $('#deletecarturl').val(),
                    data: {
                        cart_id: cart_id
                    },
                    method: 'POST',
                    success: function(response) {
                        if (response.status == 1) {
                            location.reload();
                        } else {
                            swal("Cancelled", "{{ trans('messages.wrong') }} :(",
                                "error");
                        }
                    },
                    error: function(e) {
                        swal("Cancelled", "{{ trans('messages.wrong') }} :(",
                            "error");
                    }
                });
            });
        },
    }).then((result) => {
        if (!result.isConfirmed) {
            result.dismiss === Swal.DismissReason.cancel
        }
    })
}

function placeorder() {
    var discount_amount = $('#discount_amount').val();
    var customer = $('#customer').val();
    var payment_type = $('input[name="payment_type"]:checked').val();
    
    var sub_total = $('#sub_total').val();

    var tax = $('#tax_data').val();
    var grand_total = $('#grand_total').val();
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: $('#orderurl').val(),
        data: {
            discount_amount : discount_amount,
            customer : customer,
            payment_type : payment_type,
            sub_total : sub_total,
            tax : tax,
            grand_total : grand_total,
        },
        method: 'POST',
        success: function(response) {
                $("#cartview").html('');
                $("#cartview").html(response);
                toastr.success("Order Placed!!");
                $('#pos-invoice').modal('show');
            
        },
        error: function(e) {
            swal("Cancelled", "{{ trans('messages.wrong') }} :(",
                "error");
        }
    });
}