<?php



namespace App\Http\Controllers\api;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Order;
use App\Models\User;

use App\Models\OrderDetails;
use App\Models\SystemAddons;

use Illuminate\Support\Facades\DB;

use App\helper\helper;

class HomeController extends Controller

{

     public function index(Request $request)
    {
        if($request->vendor_id == ""){
            return response()->json(["status"=>0,"message"=>trans('messages.vendor_id_required')],400);
        }
        $currency = helper::appdata($request->vendor_id)->currency;

        $currency_position = helper::appdata($request->vendor_id)->currency_position;

        $admindata = User::select('mobile','email')->where('type',1)->first();

        $revenue = Order::where('vendor_id', $request->vendor_id)->where('status', '5')->sum('grand_total');

        $totalorders = Order::where('vendor_id', $request->vendor_id)->count();

        $completedorders = Order::where('status', 5)->where('vendor_id',$request->vendor_id)->count();

        $cancelorders = Order::where('vendor_id', $request->vendor_id)->whereIn('status',[3,4])->count();

        $orderlist = order::select("id","order_number","grand_total","transaction_type","status",DB::raw('DATE_FORMAT(created_at, "%d-%m-%Y") as order_date'))->where('vendor_id', $request->vendor_id)->whereIn('status',[1, 2])->orderByDesc('id')->get();

        return response()->json(['status'=>1,'message'=>trans('messages.success'),'revenue'=>$revenue,'totalorders'=>$totalorders,'completedorders'=>$completedorders,'cancelorders'=>$cancelorders,'data'=>$orderlist,'currency'=>$currency,'currency_position'=>$currency_position,'admin_mobile' => $admindata->mobile,'admin_email'=> $admindata->email],200);

    }

    public function order_history(Request $request)
    {

        if($request->vendor_id == ""){

            return response()->json(["status"=>0,"message"=>trans('messages.vendor_id_required')],400);

        }

        $orders = Order::select("id","order_number","grand_total","transaction_type","status",DB::raw('DATE_FORMAT(created_at, "%d-%m-%Y") as order_date'))->where('vendor_id',$request->vendor_id)->orderByDesc('id')->get();

        return response()->json(['status'=>1,'message'=>trans('messages.success'),'data'=>$orders],200);

    }

    public function order_detail(Request $request)

    {

        if($request->vendor_id == ""){

            return response()->json(["status"=>0,"message"=>trans('messages.vendor_id_required')],400);

        }

        if($request->order_number == ""){

            return response()->json(["status"=>0,"message"=>trans('messages.order_number_required')],400);

        }

        $orders = Order::where('vendor_id',$request->vendor_id)->where("order_number",$request->order_number)->orderByDesc('id');

        $order =  $orders->select("id","order_number","user_name","user_email","user_mobile","grand_total","sub_total","offer_code","offer_amount","tax_amount","delivery_charge","transaction_id","transaction_type","status",DB::raw('DATE_FORMAT(created_at, "%d-%m-%Y") as order_date'),"notes")->first();

        $biilinginfo = $orders->select("billing_address","billing_landmark","billing_postal_code","billing_city","billing_state","billing_country")->first();

        $shippinginfo = $orders->select("shipping_address","shipping_landmark","shipping_postal_code","shipping_city","shipping_state","shipping_country")->first();

        $order_detail = OrderDetails::select("id","order_id","product_id","product_name",DB::raw("CONCAT('".url(env('ASSETPATHURL').'admin-assets/images/product/')."/', product_image) AS product_image"),"attribute","variation_id","variation_name","product_price","product_tax","qty")->where('order_id',$order->id)->get();

        return response()->json(['status'=>1,'message'=>trans('messages.success'),'data'=>$order,'ordrdetail'=>$order_detail,"biilinginfo"=>$biilinginfo,"shippinginfo"=>$shippinginfo],200);

    }

    public function status_change(Request $request)

    {

        if($request->vendor_id == ""){

            return response()->json(["status"=>0,"message"=>trans('messages.vendor_id_required')],400);

        }

        if($request->status == ""){

            return response()->json(["status"=>0,"message"=>trans('messages.status_required')],400);

        }
        if($request->order_number == ""){

            return response()->json(["status"=>0,"message"=>trans('messages.order_number_required')],400);

        }
        $order = Order::where('order_number', $request->order_number)->first();
        $title = "";
        $body = "";
        if ($request->status == "2") {
            $title = trans('labels.order_accepted');
            $body = 'Your Order ' . $order->order_number . ' has been accepted by Admin';
        }
        if ($request->status == "5") {
            $title = trans('labels.order_delivered');
            $body = 'Your Order ' . $order->order_number . ' has been successfully delivered.';
        }
        if ($request->status == "3") {
            $title = trans('labels.order_calcelled');
            $body = 'Order ' . $order->order_number . ' has been cancelled by Admin.';
        }
      
        $order->status = $request->status;
        $order->update();
        // customer notification for order status change
        $customer = User::where('id', $order->user_id)->first();
        helper::push_notification($customer->token, $title, $body, "order", $order->order_number, helper::appdata($request->vendor_id)->firebase);
        return response()->json(['status'=>1,'message'=>trans('messages.success')],200);
    }

    public function systemaddon(Request $request)
    {
        
        $addons = SystemAddons::select('unique_identifier', 'activated')->get();
        return response()->json(["status" => 1, "message" => trans('messages.success'), 'addons' =>  $addons], 200);
    }
}

