<?php
namespace App\Http\Controllers\api\user;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\Shippingarea;
use App\helper\helper;
use Illuminate\Support\Facades\DB;
class CartController extends Controller
{
    public function cart(Request $request)
    {
      
        if ($request->vendor_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 200);
        }
        if ($request->user_id !="" || $request->user_id != null) {
            $getcartlist = Cart::where('vendor_id', $request->vendor_id)->where('user_id',$request->user_id)->get();
        } else {
            $getcartlist = Cart::where('vendor_id', $request->vendor_id)->where('session_id', $request->session_id)->get();
        }
        foreach($getcartlist as $cart)
        {
            $cart->product_image = helper::image_path($cart->product_image);
            $cart->product_tax = helper::decimal_formate($cart->product_tax);
        }
        if (@session()->get('discount_data')['vendor_id'] != $request->vendor_id) {
            session()->forget('discount_data');
        }
        return response()->json(['status' => 1, 'message' => trans('messages.success'), 'cartdata' => $getcartlist], 200);
      
    }
    public function addtocart(Request $request)
    {
       
        if ($request->vendor_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 200);
        }
        if ($request->product_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_id_required')], 200);
        }
        if ($request->product_name == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_name_required')], 200);
        }
        if ($request->product_slug == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_slug_required')], 200);
        }
        if ($request->product_image == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_image_required')], 200);
        }
        if ($request->product_tax == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_tax_required')], 200);
        }
        if ($request->product_price == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_price_required')], 200);
        }
      
        try {
            if ($request->user_id !="" || $request->user_id != null) {
                $cart = Cart::where('vendor_id', $request->vendor_id)->where('user_id', $request->user_id)->where('product_id', $request->product_id)->first();
            } else {
                $cart = Cart::where('vendor_id', $request->vendor_id)->where('session_id',$request->session_id)->where('product_id', $request->product_id)->first();
            }
            if (!empty($cart)) {
                if ($request->variation_id > 0) {
                    if ($request->user_id !="" || $request->user_id != null) {
                        $cart = Cart::where('vendor_id', $request->vendor_id)->where('user_id', $request->user_id)->where('product_id', $request->product_id)->where('variation_id', $request->variation_id)->first();
                    } else {
                        $cart = Cart::where('vendor_id', $request->vendor_id)->where('session_id', $request->session_id)->where('product_id', $request->product_id)->where('variation_id', $request->variation_id)->first();
                    }
                    if (!empty($cart)) {
                        $cart->qty = $cart->qty + 1;
                    } else {
                        $cart = new Cart();
                        $cart->qty = 1;
                    }
                } else {
                    $cart->qty = $cart->qty + 1;
                }
            } else {
                $cart = new Cart();
                $cart->qty = 1;
            }
            $cart->vendor_id = $request->vendor_id;
            if ($request->user_id !="" || $request->user_id != null) {
                $cart->user_id = $request->user_id;
            }
            else
            {
                $cart->session_id = $request->session_id;
            }
            $cart->product_id = $request->product_id;
            $cart->product_name = $request->product_name;
            $cart->product_slug = $request->product_slug;
            $cart->product_image = $request->product_image;
            $cart->variation_id = $request->variation_id == "" ? 0 : $request->variation_id;
            $cart->variation_name = $request->variation_name == "" ? "" : $request->variation_name;
            $cart->attribute = $request->attribute == "" ? "" : $request->attribute;
            $cart->product_tax = $request->product_tax;
            $cart->product_price = $request->product_price;
            $cart->save();
            $total_cart_count = helper::getcartcount($request->vendor_id, $request->session_id,$request->user_id);
            return response()->json(['status' => 1, 'message' => trans('messages.success'), 'total_cart_count' => $total_cart_count], 200);
        } catch (\Throwable $th) {
            return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
        }
    }
    public function qtyupdate(Request $request)
    {
        if ($request->vendor_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 200);
        }
        if ($request->product_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.product_id_required')], 200);
        }
        if ($request->type == "") {
            return response()->json(["status" => 0, "message" => trans('messages.type_required')], 200);
        }
        if ($request->user_id !="" || $request->user_id != null) {
            $checkcart = Cart::where('user_id', $request->user_id)->where('vendor_id', $request->vendor_id);
        }
        else
        {
            $checkcart = Cart::where('session_id', $request->session_id)->where('vendor_id', $request->vendor_id);
        }
       
        if ($request->product_id != "") {
            $checkcart = $checkcart->where('product_id', $request->product_id);
        }
        if ($request->variation_id != "") {
            $checkcart = $checkcart->where('variation_id', $request->variation_id);
        }
      
        $checkcart = $checkcart->first();
        if (!empty($checkcart)) {
            try {
                if (in_array($request->type, ['minus', 'plus'])) {
                    if ($checkcart->qty == 1 && $request->type == "minus") {
                        $checkcart->delete();
                        session()->forget('discount_data');
                    } else {
                        if ($request->type == "plus") {
                            $checkcart->qty += 1;
                        }
                        if ($request->type == "minus") {
                            $checkcart->qty -= 1;
                            session()->forget('discount_data');
                        }
                        $checkcart->save();
                    }
                 return response()->json(['status' => 1, 'message' => trans('messages.success')], 200);
                    
                } else {
                    return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
                }
            } catch (\Throwable $th) {
                return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
            }
        } else {
            return response()->json(['status' => 0, 'message' => trans('messages.nodata_found')], 200);
        }
    }
    public function shippingarea(Request $request)
    {
        if ($request->vendor_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 200);
        }
        if ($request->user_id != "") {
            $cart = Cart::select(DB::raw('SUM((qty)*(product_price)) AS sub_total'),DB::raw('SUM((qty)*(product_tax)) AS total_tax'))->where('user_id',$request->user_id)->where('vendor_id',$request->vendor_id)->first();
        }
        else
        {
            $cart = Cart::select(DB::raw('SUM((qty)*(product_price)) AS sub_total'),DB::raw('SUM((qty)*(product_tax)) AS total_tax'))->where('session_id',$request->session_id)->where('vendor_id',$request->vendor_id)->first();
        }
        $shippingarea = Shippingarea::select('id','vendor_id','name','delivery_charge')->where('vendor_id',$request->vendor_id)->where('is_available',1)->get();
        return response()->json(["status"=>1,"message"=>trans('messages.success'),'shippingarea'=>$shippingarea,'sub_total'=> $cart->sub_total,'total_tax'=>$cart->total_tax ],200);
    }
}