<?php

namespace App\Http\Controllers\api\user;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\Order;
use App\Models\User;
use App\Models\OrderDetails;
use App\Models\SystemAddons;
use Illuminate\Support\Facades\DB;
use Stripe;

class OrderController extends Controller
{
    public function placeorder(Request $request)
    {
        $transaction_id = $request->transaction_id;
        if ($request->vendor_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 400);
        }
        if ($request->user_name == "") {
            return response()->json(["status" => 0, "message" => trans('messages.user_name_required')], 400);
        }
        if ($request->user_email == "") {
            return response()->json(["status" => 0, "message" => trans('messages.user_email_required')], 400);
        }
        if ($request->user_mobile == "") {
            return response()->json(["status" => 0, "message" => trans('messages.user_mobile_required')], 400);
        }
        if ($request->transaction_type == "") {
            return response()->json(["status" => 0, "message" => trans('messages.transaction_type_required')], 400);
        }
        if ($request->billing_address == "") {
            return response()->json(["status" => 0, "message" => trans('messages.billing_address_required')], 400);
        }
        if ($request->billing_landmark == "") {
            return response()->json(["status" => 0, "message" => trans('messages.billing_landmark_required')], 400);
        }
        if ($request->billing_postal_code == "") {
            return response()->json(["status" => 0, "message" => trans('messages.billing_postal_code_required')], 400);
        }
        if ($request->billing_city == "") {
            return response()->json(["status" => 0, "message" => trans('messages.billing_city_required')], 400);
        }
        if ($request->billing_state == "") {
            return response()->json(["status" => 0, "message" => trans('messages.billing_state_required')], 400);
        }
        if ($request->billing_country == "") {
            return response()->json(["status" => 0, "message" => trans('messages.billing_country_required')], 400);
        }
        if ($request->shipping_address == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_address_required')], 400);
        }
        if ($request->shipping_landmark == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_landmark_required')], 400);
        }
        if ($request->shipping_postal_code == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_postal_code_required')], 400);
        }
        if ($request->shipping_city == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_city_required')], 400);
        }
        if ($request->shipping_state == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_state_required')], 400);
        }
        if ($request->shipping_country == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_country_required')], 400);
        }
        if ($request->shipping_area == "") {
            return response()->json(["status" => 0, "message" => trans('messages.shipping_area_required')], 400);
        }
        if ($request->delivery_charge == "") {
            return response()->json(["status" => 0, "message" => trans('messages.delivery_charge_required')], 400);
        }
        if ($request->grand_total == "") {
            return response()->json(["status" => 0, "message" => trans('messages.grand_total_required')], 400);
        }
        if ($request->sub_total == "") {
            return response()->json(["status" => 0, "message" => trans('messages.sub_total_required')], 400);
        }
        if ($request->tax_amount == "") {
            return response()->json(["status" => 0, "message" => trans('messages.tax_amount_required')], 400);
        }

        if ($request->transaction_type == "3") {
            $stripekey = helper::stripe_data($request->vendor_id)->secret_key;
            $stripe = new \Stripe\StripeClient($stripekey);
            $gettoken = $stripe->tokens->create([
                'card' => [
                    'number' => $request->card_number,
                    'exp_month' => $request->card_exp_month,
                    'exp_year' => $request->card_exp_year,
                    'cvc' => $request->card_cvc,
                ],
            ]);
            Stripe\Stripe::setApiKey($stripekey);
            $payment = Stripe\Charge::create([
                "amount" => $request->grand_total * 100,
                "currency" => helper::stripe_data($request->vendor_id)->currency,
                "source" => $gettoken->id,
                "description" => "Ecom-SAAS-OrderPayment",
            ]);
            $transaction_id = $payment->id;
        }

        $vendordata = User::where('id', $request->vendor_id)->first();
        $data = helper::createorder($vendordata->slug, $request->session_id, $request->user_id, $request->user_name, $request->user_email, $request->user_mobile, $request->transaction_type, $transaction_id, $request->billing_address, $request->billing_landmark, $request->billing_postal_code, $request->billing_city, $request->billing_state, $request->billing_country, $request->shipping_address, $request->shipping_landmark, $request->shipping_postal_code, $request->shipping_city, $request->shipping_state, $request->shipping_country, $request->shipping_area, $request->delivery_charge, $request->grand_total, $request->sub_total, $request->tax_amount, $request->notes, $request->offer_code, $request->offer_amount, '');
        $data = json_decode(json_encode($data), true);
        if ($data['original']['status'] == 1) {
            if (SystemAddons::where('unique_identifier', 'whatsapp_message')->first() != null && SystemAddons::where('unique_identifier', 'whatsapp_message')->first()->activated == 1) {
                $whmessage = helper::whatsappmessage($data['original']['order_number'], $vendordata->slug, $vendordata);
                $whatsapp_number = helper::appdata($vendordata->id)->whatsapp_number;
            } else {
                $whmessage = "";
                $whatsapp_number = "";
            }
            // vendor notification
            $vendortitle = trans('labels.order_placed');
            $vendorbody = trans('messages.new_order_arrive') . ' #' . $data['original']['order_number'];
            $vendordata = User::where('id', $request->vendor_id)->first();
            helper::push_notification($vendordata->token, $vendortitle, $vendorbody, "order", $data['original']['order_number'], @helper::appdata('')->firebase);

            // customer notification
            $customertitle = trans('labels.order_placed');
            $customerbody = trans('messages.order_placed') . ' #' . $data['original']['order_number'];
            $customer = User::where('id', $request->user_id)->first();
            helper::push_notification($customer->token, $customertitle, $customerbody, "order", $data['original']['order_number'], helper::appdata($request->vendor_id)->firebase);

            return response()->json(["status" => 1, "message" => trans('messages.success'), 'whmessage' => $whmessage, "whatsapp_number" => $whatsapp_number, 'order_number' => $data['original']['order_number']], 200);
        } else {
            return response()->json(["status" => 0, "message" => $data['original']['message']], 200);
        }
    }
    public function orderhistory(Request $request)
    {
        if ($request->vendor_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 400);
        }
        if ($request->user_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.user_id_required')], 400);
        }
        $orders = Order::select("id", "order_number", "grand_total", "transaction_type", "status", DB::raw('DATE_FORMAT(created_at, "%d-%m-%Y") as order_date'))->where('vendor_id', $request->vendor_id)->where('user_id', $request->user_id)->orderByDesc('id')->get();
        return response()->json(['status' => 1, 'message' => trans('messages.success'), 'data' => $orders], 200);
    }
    public function orderdetails(Request $request)
    {
        if ($request->vendor_id == "") {

            return response()->json(["status" => 0, "message" => trans('messages.vendor_id_required')], 400);
        }
        if ($request->order_number == "") {
            return response()->json(["status" => 0, "message" => trans('messages.order_number_required')], 400);
        }
        $orders = Order::where('vendor_id', $request->vendor_id)->where("order_number", $request->order_number)->orderByDesc('id');
        $order =  $orders->select("id", "order_number", "user_name", "user_email", "user_mobile", "grand_total", "sub_total", "offer_code", "offer_amount", "tax_amount", "delivery_charge", "transaction_id", "transaction_type", "status", DB::raw('DATE_FORMAT(created_at, "%d-%m-%Y") as order_date'), "notes")->first();
        $order->grand_total = helper::decimal_formate($order->grand_total);
        $order->tax_amount = helper::decimal_formate($order->tax_amount);
        $order->sub_total = helper::decimal_formate($order->sub_total);
        $order->offer_code = helper::decimal_formate($order->offer_code);
        $biilinginfo = $orders->select("billing_address", "billing_landmark", "billing_postal_code", "billing_city", "billing_state", "billing_country")->first();

        $shippinginfo = $orders->select("shipping_address", "shipping_landmark", "shipping_postal_code", "shipping_city", "shipping_state", "shipping_country")->first();

        $order_detail = OrderDetails::select("id", "order_id", "product_id", "product_name", DB::raw("CONCAT('" . url(env('ASSETPATHURL') . 'admin-assets/images/product/') . "/', product_image) AS product_image"), "attribute", "variation_id", "variation_name", "product_price", "product_tax", "qty")->where('order_id', $order->id)->get();
        foreach ($order_detail as $detail) {
            $detail->product_price = helper::decimal_formate($detail->product_price);
            $detail->product_tax = helper::decimal_formate($detail->product_tax);
        }
        return response()->json(['status' => 1, 'message' => trans('messages.success'), 'data' => $order, 'ordrdetail' => $order_detail, "biilinginfo" => $biilinginfo, "shippinginfo" => $shippinginfo], 200);
    }
    public function cancelorder(Request $request)
    {
        if ($request->order_number == "") {
            return response()->json(["status" => 0, "message" => trans('messages.order_number_required')], 400);
        }
        if ($request->user_id == "") {
            return response()->json(["status" => 0, "message" => trans('messages.user_id_required')], 400);
        }
        $order = Order::where('order_number', $request->order_number)->first();
        if ($order->status == 1 || $order->status == 2) {
            $order->status = 4;
            $order->update();

            // vendor notification for order cancel
            $vendortitle = trans('labels.order_calcelled');
            $vendorbody = trans('messages.order_calcelled_by_user') . ' #' . $order->vendor_id;
            $vendordata = User::where('id', $order->vendor_id)->first();
            helper::push_notification($vendordata->token, $vendortitle, $vendorbody, "order", $order->vendor_id, @helper::appdata('')->firebase);

            // customer notification for order cancel
            $customertitle = trans('labels.order_calcelled');
            $customerbody = trans('messages.order_calcelled') . ' #' . $request->order_number;
            $customer = User::where('id', $request->user_id)->first();
            helper::push_notification($customer->token, $customertitle, $customerbody, "order", $request->order_number, helper::appdata($request->vendor_id)->firebase);
            return response()->json(['status' => 1, 'message' => trans('messages.success')], 200);
        } else {
            return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 400);
        }
    }
}
