<?php
namespace App\Http\Controllers\web;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\Cart;
use App\Models\Promocode;
use App\Models\Order;
use App\Models\Settings;
use App\Models\Products;
use App\Models\Variation;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
class CartController extends Controller
{
    public function index(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }
       
        if(empty($vendordata))
        {
            abort(404);
        }
        if (Auth::user() && Auth::user()->type == 3) {
            $getcartlist = Cart::where('vendor_id', @$vdata)->where('user_id', Auth::user()->id)->get();
        } else {
            $getcartlist = Cart::where('vendor_id', @$vdata)->where('session_id', session()->getId())->get();
        }
        $dt = date('Y-m-d');
        $getpromocodelist = Promocode::where('start_date', '<=', $dt)
        ->where('exp_date', '>=', $dt)
        ->where('vendor_id', $vdata)
        ->orderBy('id', 'DESC')
        ->get();
        if (@session()->get('discount_data')['vendor_id'] != @$vdata) {
            session()->forget('discount_data');
        }
        return view('web.cart.index', compact('vendordata', 'getcartlist', 'getpromocodelist'));
    }
    public function addtocart(Request $request)
    {
       
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }
        if(empty($vendordata))
        {
            abort(404);
        }
        try {
            $product = Products::where('id',$request->product_id)->where('vendor_id',$vdata)->first();
            $variation = Variation::where('product_id',$request->product_id)->where('id',$request->variation_id)->first();
            if (Auth::user() && Auth::user()->type == 3) {
                $cart = Cart::where('vendor_id', @$vdata)->where('user_id', Auth::user()->id)->where('product_id', $request->product_id)->first();
            } else {
                $cart = Cart::where('vendor_id', @$vdata)->where('session_id', session()->getId())->where('product_id', $request->product_id)->first();
            }
           
            if (!empty($cart)) {
                if ($request->variation_id > 0) {
                    if (Auth::user() && Auth::user()->type == 3) {
                        $cart = Cart::where('vendor_id', @$vdata)->where('user_id', Auth::user()->id)->where('product_id', $request->product_id)->where('variation_id', $request->variation_id)->first();
                    } else {
                        $cart = Cart::where('vendor_id', @$vdata)->where('session_id', session()->getId())->where('product_id', $request->product_id)->where('variation_id', $request->variation_id)->first();
                    }
                  
                    if (!empty($cart)) {
                            if($cart->qty < $variation->qty)
                            {
                                $cart->qty = $cart->qty + 1;
                            }
                            else{
                                return response()->json(['status' => 0, 'message' => trans('messages.out_of_stock')], 200);
                            }
                    } else {
                        if($variation->qty > 0)
                        {
                            $cart = new Cart();
                            $cart->qty = 1;
                        }else{
                            return response()->json(['status' => 0, 'message' => trans('messages.out_of_stock')], 200);
                        }
                    }
                } else {
                    if($product->qty > $cart->qty)
                    {
                        $cart->qty = $cart->qty + 1;
                    }
                    else{
                        return response()->json(['status' => 0, 'message' => trans('messages.out_of_stock')], 200);
                    }
                }
            } else {
                if($request->variation_id !=null)
                {
                    if($variation->qty > 0)
                    {
                        $cart = new Cart();
                        $cart->qty = 1;
                    }
                    else{
                        return response()->json(['status' => 0, 'message' => trans('messages.out_of_stock')], 200);
                    }

                }
                else{
                    if($product->qty > 0)
                    {
                        $cart = new Cart();
                        $cart->qty = 1;
                    }else
                    {
                        return response()->json(['status' => 0, 'message' => trans('messages.out_of_stock')], 200);
                    }
                }
              
            }
            $cart->vendor_id = @$vdata;
            if (Auth::user() && Auth::user()->type == 3) {
                $cart->user_id = Auth::user()->id;
            }
            else
            {
                $cart->session_id = session()->getId();
            }
            $cart->product_id = $request->product_id;
            $cart->product_name = $request->product_name;
            $cart->product_slug = $request->product_slug;
            $cart->product_image = $request->product_image;
            $cart->variation_id = $request->variation_id == "" ? 0 : $request->variation_id;
            $cart->variation_name = $request->variation_name == "" ? "" : $request->variation_name;
            $cart->attribute = $request->attribute == "" ? "" : $request->attribute;
            $cart->product_tax = $request->product_tax;
            $cart->product_price = $request->product_price;
            $cart->save();
            $total_cart_count = helper::getcartcount(@$vdata, session()->getId(), Auth::user() && Auth::user()->type == 3 ? Auth::user()->id : "");
            return response()->json(['status' => 1, 'message' => trans('messages.success'), 'total_cart_count' => $total_cart_count], 200);
        } catch (\Throwable $th) {
            return response()->json(['status' => 0, 'message' => trans('messages.wrong')], 200);
        }
    }
    public function clearcart(Request $request)
    {
    
        try {
            $host = $_SERVER['HTTP_HOST'];
            if ($host  ==  env('WEBSITE_HOST')) {
                $vendordata = helper::vendordata($request->vendor_slug);

                $vdata = $vendordata->id;
            }
            // if the current host doesn't contain the website domain (meaning, custom domain)
            else {
                $vendordata = Settings::where('custom_domain', $host)->first();
                
                $vdata = $vendordata->vendor_id;
            }
       
            if(empty($vendordata))
            {
                abort(404);
            }

            if (Auth::user() && Auth::user()->type == 3) {
                $getcartlist = Cart::where('user_id', Auth::user()->id)->where('vendor_id', @$vdata);
            } else {
                $getcartlist = Cart::where('session_id', session()->getId())->where('vendor_id', @$vdata);
            }
           
            if ($request->pid != "") {
                $getcartlist = $getcartlist->where('product_id', $request->pid);
            }
            if ($request->vid != "") {
                $getcartlist = $getcartlist->where('variation_id', $request->vid);
            }
            $getcartlist = $getcartlist->get();
           
            $getcartlist = $getcartlist->each->delete();
            session()->forget('discount_data');
            return redirect($request->vendor_slug . '/cart')->with('success', trans('messages.success'));
        } catch (\Throwable $th) {
           return $th;
        }
    }
    public function qtyupdate(Request $request)
    {
     
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);

            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            
            $vdata = $vendordata->vendor_id;
        }
       
        if(empty($vendordata))
        {
            abort(404);
        }
        if (Auth::user() && Auth::user()->type == 3) {
            $checkcart = Cart::where('user_id', Auth::user()->id)->where('vendor_id', @$vdata);
        }
        else
        {
            $checkcart = Cart::where('session_id', session()->getId())->where('vendor_id', @$vdata);
        }
        if ($request->pid != "") {
            $checkcart = $checkcart->where('product_id', $request->pid);
        }
        if ($request->vid != "") {
            $checkcart = $checkcart->where('variation_id', $request->vid);
        }
        $checkcart = $checkcart->first();
        if (!empty($checkcart)) {
            try {
                if (in_array($request->type, ['minus', 'plus'])) {
                    if ($checkcart->qty == 1 && $request->type == "minus") {
                        $checkcart->delete();
                        session()->forget('discount_data');
                    } else {
                        if ($request->type == "plus") {
                            if($request->vid !="" && $request->vid !=0)
                            {
                                $variant = Variation::where('id',$request->vid)->where('product_id',$request->pid)->first();
                                if($checkcart->qty >= $variant->qty)
                                {
                                    return redirect($request->vendor_slug . '/cart')->with('error', trans('messages.out_of_stock'));
                                }else{
                                    $checkcart->qty += 1;
                                }
                            }
                            else{
                                $product = Products::where('id',$request->pid)->where('vendor_id',$checkcart->vendor_id)->first();
                                if($checkcart->qty >= $product->qty)
                                {
                                    return redirect($request->vendor_slug . '/cart')->with('error', trans('messages.out_of_stock'));
                                }else{
                                    $checkcart->qty += 1;
                                }
                            }
                            
                        }
                        if ($request->type == "minus") {
                            $checkcart->qty -= 1;
                            session()->forget('discount_data');
                        }
                        $checkcart->save();
                    }
                    session()->forget('discount_data');
                    return redirect($request->vendor_slug . '/cart')->with('success', trans('messages.success'));
                } else {
                    return redirect($request->vendor_slug . '/cart')->with('error', trans('messages.wrong'));
                }
            } catch (\Throwable $th) {
                return redirect($request->vendor_slug . '/cart')->with('error', trans('messages.wrong'));
            }
        } else {
            return redirect($request->vendor_slug . '/cart')->with('error', trans('messages.nodata_found'));
        }
       
    }
    public function applypromocode(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'offer_code' => 'required',
            'subtotal' => 'required',
        ], [
            "offer_code.required" => trans('messages.promocode_required'),
            "subtotal.required" => trans('messages.wrong'),
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $host = $_SERVER['HTTP_HOST'];
            if ($host  ==  env('WEBSITE_HOST')) {
                $vendordata = helper::vendordata($request->vendor_slug);

                $vdata = $vendordata->id;
            }
            // if the current host doesn't contain the website domain (meaning, custom domain)
            else {
                $vendordata = Settings::where('custom_domain', $host)->first();
                
                $vdata = $vendordata->vendor_id;
            }
       
            if(empty($vendordata))
            {
                abort(404);
            }
            date_default_timezone_set(helper::appdata(@$vdata)->timezone);
            $checkoffercode = Promocode::where('offer_code', $request->offer_code)->where('vendor_id', @$vdata)->where('is_available', 1)->first();
            if (!empty($checkoffercode)) {
                if ((date('Y-m-d') >= $checkoffercode->start_date) && (date('Y-m-d') <= $checkoffercode->exp_date)) {
                    if ($request->subtotal >= $checkoffercode->min_amount) {
                        if ($checkoffercode->usage_type == 1) {
                            if (Auth::user() && Auth::user()->type == 3) {
                            $checkcount = Order::select('offer_code')->where('offer_code', $request->offer_code)->where('vendor_id', @$vdata)->where('user_id', Auth::user()->id)->count();
                            }
                            else
                            {
                                $checkcount = Order::select('offer_code')->where('offer_code', $request->offer_code)->where('vendor_id', @$vdata)->where('session_id', session()->getId())->count();
                            }
                            if ($checkcount >= $checkoffercode->usage_limit) {
                                return redirect()->back()->with('error', trans('messages.usage_limit_exceeded'))->withInput();
                            }
                        }
                        $offer_amount = $checkoffercode->offer_amount;
                        if ($checkoffercode->offer_type == 2) {
                            $offer_amount = $request->subtotal * $checkoffercode->offer_amount / 100;
                        }
                        $arr = array(
                            "offer_code" => $checkoffercode->offer_code,
                            "offer_amount" => $offer_amount,
                            "vendor_id" => @$vdata,
                        );
                        session()->put('discount_data', $arr);
                        return redirect()->back()->with('success', trans('messages.success'));
                    } else {
                        return redirect()->back()->with('error', trans('messages.order_amount_greater_then') . ' ' . helper::currency_formate($checkoffercode->min_amount, @$vdata))->withInput();
                    }
                } else {
                    return redirect()->back()->with('error', trans('messages.invalid_promocode'))->withInput();
                }
            } else {
                return redirect()->back()->with('error', trans('messages.invalid_promocode'))->withInput();
            }
        }
    }
    public function removepromocode()
    {
        if (session()->has('discount_data')) {
            session()->forget('discount_data');
            return redirect()->back()->with('success', trans('messages.success'));
        }
        abort(404);
    }
}
