<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\helper\helper;
use App\Models\Products;
use App\Models\Category;
use App\Models\Settings;
use App\Models\OrderDetails;
use App\Models\SubCategory;
use App\Models\Testimonials;
use App\Models\TopDeals;
use App\Models\User;
use URL;
use DB;
use Illuminate\Support\Facades\Auth;

class ProductController extends Controller
{
    public function productdetails(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        if (empty($vendordata)) {
            abort(404);
        }
        $productdata = Products::with('multi_image', 'category_info', 'subcategory_info')->where('slug', $request->product_slug)->where('vendor_id', $vdata)->where('is_available', 1)->where('is_deleted', 2)->first();
        if ($request->has('type') == 1 && $request->type == 1) {
            $getrelatedproductslist = Products::with('multi_image', 'category_info', 'subcategory_info')->where('id', '!=', @$productdata->id)->where('category_id', @$productdata->category_id)->where('vendor_id', $vdata)->where('is_available', 1)->where('is_deleted', 2)->where('top_deals', 1)->orderBy('reorder_id')->get();
        } else {
            $getrelatedproductslist = Products::with('multi_image', 'category_info', 'subcategory_info')->where('id', '!=', @$productdata->id)->where('category_id', @$productdata->category_id)->where('vendor_id', $vdata)->where('is_available', 1)->where('is_deleted', 2)->where('top_deals', '!=', 1)->orderBy('reorder_id')->get();
        }

        $review = Testimonials::where('vendor_id', $vendordata->id)->where('product_id', $productdata->id)->get();
        $averagerating = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->avg('star');
        $totalreview = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->count();
        $fivestaraverage = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->where('star', 5)->avg('star');
        $fourstaraverage = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->where('star', 4)->avg('star');
        $threestaraverage = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->where('star', 3)->avg('star');
        $twostaraverage = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->where('star', 2)->avg('star');
        $onestaraverage = Testimonials::where('product_id', $productdata->id)->where('vendor_id', $vendordata->id)->where('star', 1)->avg('star');
        return view('web.productdetails', compact('vendordata', 'productdata', 'getrelatedproductslist', 'review', 'averagerating', 'totalreview', 'fivestaraverage', 'fourstaraverage', 'threestaraverage', 'twostaraverage', 'onestaraverage'));
    }
    public function category_wise_products(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        if (empty($vendordata)) {
            abort(404);
        }
        if ($request->has('category')) {
            $category_slug = $request->category;
        } else {
            $category_slug = $request->category_slug;
        }
        if ($request->has('subcategory')) {
            $subcategory_slug = $request->subcategory;
        } else {
            $subcategory_slug = $request->categorsubcategory_slugy_slug;
        }
        // CHECK VALID CATEGORY
        $getcategorydata = Category::select('id', 'name', 'slug', 'image')->where('slug', $category_slug)->where('is_available', 1)->where('is_deleted', 2)->where('vendor_id', $vdata)->first();
        if (!empty($request->category_slug) && empty($getcategorydata)) {
            return redirect(@$vendordata->slug . '/categories');
        }

        // CHECK VALID SUBCATEGORY
        $getsubcategorydata = SubCategory::select('id', 'category_id', 'name', 'slug')->where('slug', $subcategory_slug)->where('category_id', @$getcategorydata->id)->where('is_available', 1)->where('is_deleted', 2)->where('vendor_id', $vdata)->first();
        if (!empty($request->subcategory_slug) && empty($getsubcategorydata)) {
            if (!empty($request->category_slug) && empty($getcategorydata)) {
                return redirect(@$vendordata->slug . '/categories');
            }
            return redirect(@$vendordata->slug . '/categories-' . $getcategorydata->slug);
        }
        // GET PRODUCTS LIST
        $getproductslist = Products::with('product_image', 'multi_variation', 'category_info')
            ->select('products.*', DB::raw('ROUND(AVG(testimonials.star),1) as ratings_average'))
            ->leftJoin('testimonials', 'testimonials.product_id', '=', 'products.id')
            ->groupBy('products.id')
            ->where('products.is_available', "1")
            ->where('products.top_deals', '!=', '1')
            ->where('products.is_deleted', "2")->where('products.vendor_id', $vdata);

        if (!empty($getcategorydata)) {
            $getproductslist = $getproductslist->where('products.category_id', $getcategorydata->id);
        }
        if (!empty($getsubcategorydata)) {
            $getproductslist = $getproductslist->where('products.sub_category_id', $getsubcategorydata->id);
        }
        $fromprice = (int)$request->from;
        $toprice = (int)$request->to;
        if ($request->has('from') && $fromprice >= 0 && $request->has('to') && $toprice > 0) {
            $getproductslist = $getproductslist->whereBetween('products.price', [$fromprice, $toprice]);
        }
        if ($request->has('name') && $request->name != "") {
            $getproductslist = $getproductslist->where('products.name', 'like', '%' . $request->name . '%');
        }
        // Sortby
        if ($request->type == "oldest") {
            $getproductslist = $getproductslist->orderBy('products.reorder_id');
        } elseif ($request->type == "price-low-high") {
            $getproductslist = $getproductslist->orderBy('products.price');
        } elseif ($request->type == "price-high-low") {
            $getproductslist = $getproductslist->orderByDesc('products.price');
        } elseif ($request->type == "best-selling-products") {
            $getproductslist = $getproductslist->inRandomOrder();
        } else {
            // type = "" || "all" || "newest"
            $getproductslist = $getproductslist->orderByDesc('products.reorder_id');
        }
        $subcategories = [];
        if ($request->category_slug != null && $request->category_slug != "") {
            $category = Category::where('slug', $request->category_slug)->first();
            $subcategories = SubCategory::where('category_id', $category->id)->get();
        }
        if ($request->has('category') && $request->category != "") {
            $category = Category::where('slug', $request->category)->first();
            $subcategories = SubCategory::where('category_id', $category->id)->get();
        }
        $getproductslist = $getproductslist->paginate(20);
        return view('web.viewallproducts', compact('vendordata', 'getproductslist', 'getcategorydata', 'getsubcategorydata', 'subcategories'));
    }
    public function getproductdata(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
            $vdata = $vendordata->id;
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
            $vdata = $vendordata->vendor_id;
        }
        if (empty($vendordata)) {
            abort(404);
        }
        $totalratting = Testimonials::where('product_id', $request->id)->where('vendor_id', $vdata)->count();
        $getproductdata = Products::with('product_image', 'multi_image', 'multi_variation', 'category_info')
            ->select('products.*', DB::raw('ROUND(AVG(testimonials.star),1) as ratings_average'))
            ->leftJoin('testimonials', 'testimonials.product_id', '=', 'products.id')
            ->where('products.is_available', "1")
            ->where('products.is_deleted', "2")
            ->where('products.vendor_id', $vdata)
            ->where('products.id', $request->id)
            ->first();
        return response()->json(['status' => 1, 'message' => trans('messages.success'), 'productdata' => $getproductdata, 'totalratting' => $totalratting], 200);
    }
    public function postreview(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }
        if (empty($vendordata)) {
            abort(404);
        }
        $product = Products::where('id', $request->product_id)->first();
        if (Auth::user() && Auth::user()->type == 3) {

            $orders = OrderDetails::where('user_id', Auth::user()->id)->where('vendor_id', $vendordata->id)->where('product_id', $request->product_id)->count();
            $rattingcount = Testimonials::where('user_id', Auth::user()->id)->where('product_id', $request->product_id)->where('vendor_id', $vendordata->id)->count();
            if ($orders > 0 && $rattingcount == 0) {
                $user = User::where('id', Auth::user()->id)->first();
                $review = new Testimonials();
                $review->vendor_id = $vendordata->id;
                $review->user_id = Auth::user()->id;
                $review->product_id = $request->product_id;
                $review->star = $request->ratting;
                $review->description = $request->review;
                $review->name = $user->name;
                $review->image = $user->image;
                $review->save();
                return redirect()->back()->with('success', trans('messages.success'));
            } else {
                return redirect()->back()->with('error', trans('messages.post_review_message'));
            }
        } else {
            session()->put('previous_url', URL::to($vendordata->slug . '/products/' . $product->slug));
            return redirect($vendordata->slug . '/login');
        }
    }
    public function alltopdeals(Request $request)
    {
        $host = $_SERVER['HTTP_HOST'];
        if ($host  ==  env('WEBSITE_HOST')) {
            $vendordata = helper::vendordata($request->vendor_slug);
        }
        // if the current host doesn't contain the website domain (meaning, custom domain)
        else {
            $vendordata = Settings::where('custom_domain', $host)->first();
        }
        if (empty($vendordata)) {
            abort(404);
        }
        $topdealsproducts = Products::with('product_image', 'multi_variation', 'category_info')
            ->select('products.*', DB::raw('ROUND(AVG(testimonials.star),1) as ratings_average'))
            ->leftJoin('testimonials', 'testimonials.product_id', '=', 'products.id')
            ->groupBy('products.id')
            ->where('products.is_available', "1")
            ->where('products.top_deals', '1')
            ->where('products.is_deleted', "2")->where('products.vendor_id', $vendordata->id)->paginate(20);
        $topdeals = TopDeals::where('vendor_id', $vendordata->id)->first();
        return view('web.viewalltopdeals', compact('topdealsproducts', 'vendordata', 'topdeals'));
    }
}
