<?php

namespace App\Imports;

use Illuminate\Support\Facades\Auth;
use App\Models\Products;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Str;

class ImportProduct implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
       return new Products([
            'vendor_id' => Auth::user()->id,
            'category_id' => $row['category_id'],
            'sub_category_id' => $row['sub_category_id'],
            'name' => $row['product_name'],
            'slug' => Str::slug($row['product_name'] . ' ' , '-').'-'.Str::random(5),
            'price' => $row['price'],
            'original_price' => $row['original_price'],
            'tax' => $row['tax'],
            'description' => $row['description'],
            'additional_info' => $row['additional_description'],
        ]);
      
    }
    public function headingRow(): int
    {
        return 1;
    }
}
