@extends('admin.layout.default')
@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="text-uppercase">{{ trans('labels.invoice') }}</h5>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ URL::to('admin/orders') }}">{{ trans('labels.orders') }}</a>
                </li>
                <li class="breadcrumb-item active {{ session()->get('direction') == 2 ? 'breadcrumb-rtl' : '' }}"
                    aria-current="page">{{ trans('labels.invoice') }}</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-lg-5 col-xl-4">
            {{-- order info --}}
            <div class="card border-0 mb-3">
                <div class="card-body">
                    <div class="card-header text-center">
                        <h4 class="card-title mb-0">#{{ $getorderdata->order_number }}</h4>
                    </div>
                    <div class="basic-list-group">
                        <ul class="list-group list-group-flush">
                             {{-- payment_type = COD : 1,RazorPay : 2, Stripe : 3, Flutterwave : 4, Paystack : 5, Bank transfer : 6, Mercado Pago : 7, PayPal : 8, MyFatoorah : 9, toyyibpay : 10 --}}
                             <li class="list-group-item px-0 d-flex justify-content-between">
                                {{ trans('labels.payment_type') }}
                                <span>
                                    @if ($getorderdata->transaction_type == 6)
                                        {{ @helper::getpayment($getorderdata->transaction_type, $getorderdata->vendor_id)->payment_name }}
                                        : <small><a href="{{ helper::image_path($transaction->screenshot) }}"
                                                target="_blank"
                                                class="text-danger">{{ trans('labels.click_here') }}</a></small>
                                    @else
                                        {{ @helper::getpayment($getorderdata->transaction_type, $getorderdata->vendor_id)->payment_name }}
                                    @endif
                                </span>
                            </li>
                            @if (in_array($getorderdata->transaction_type, [2, 3, 4, 5, 7, 8, 9, 10]))
                                <li class="list-group-item px-0">{{ trans('labels.transaction_id') }}<p class="text-muted">
                                        {{ $getorderdata->transaction_id }}</p>
                                </li>
                            @endif
                        </ul>
                    </div>
                    @if ($getorderdata->notes != '')
                        <h6>{{ trans('labels.order_notes') }}</h6>
                        <small class="text-muted">{{ $getorderdata->notes }}</small>
                    @endif
                </div>
            </div>
            {{-- user info --}}
            <div class="card border-0 mb-3">
                <div class="card-body">
                    <div class="basic-list-group">
                        <div class="row">
                            <div class="col-md-12 my-2">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item px-0 d-flex align-items-center py-0">
                                        <h6 class="m-2"><i class="fa-regular fa-user"></i></h6>
                                        {{ $getorderdata->user_name }}
                                    </li>
                                    @if ($getorderdata->user_mobile != null)
                                        <li class="list-group-item px-0 d-flex align-items-center py-0">
                                            <h6 class="m-2"><i class="fa-regular fa-phone"></i></h6>
                                            {{ $getorderdata->user_mobile }}
                                        </li>
                                    @endif
                                    @if ($getorderdata->user_email != null)
                                        <li class="list-group-item px-0 d-flex align-items-center py-0">
                                            <h6 class="m-2"><i class="fa-regular fa-envelope"></i></h6>
                                            {{ $getorderdata->user_email }}
                                        </li>
                                    @endif
                                </ul>
                            </div>
                            @if ($getorderdata->order_from != 'pos')
                                <h5 class="mt-2 text-underline"> {{ trans('labels.address_details') }} </h5>

                                <div class="col-md-12 my-2">
                                    <nav>
                                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                            <button class="nav-link active" id="nav-home-tab" data-bs-toggle="tab"
                                                data-bs-target="#nav-home" type="button" role="tab"
                                                aria-controls="nav-home" aria-selected="true"> <i
                                                    class="fa-regular fa-file-lines"></i>
                                                {{ trans('labels.billing') }}</button>
                                            <button class="nav-link" id="nav-profile-tab" data-bs-toggle="tab"
                                                data-bs-target="#nav-profile" type="button" role="tab"
                                                aria-controls="nav-profile" aria-selected="true"> <i
                                                    class="fa-regular fa-truck-fast"></i>
                                                {{ trans('labels.shipping') }}</button>
                                        </div>
                                    </nav>
                                    <div class="tab-content" id="nav-tabContent">
                                        <div class="tab-pane fade show active" id="nav-home" role="tabpanel"
                                            aria-labelledby="nav-home-tab">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.address') }} : {{ $getorderdata->billing_address }}
                                                </li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.landmark') }} : {{ $getorderdata->billing_landmark }}
                                                </li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.postalcode') }} :
                                                    {{ $getorderdata->billing_postal_code }}</li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.city') }} : {{ $getorderdata->billing_city }}</li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.state') }} : {{ $getorderdata->billing_state }}</li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.country') }} : {{ $getorderdata->billing_country }}
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane fade" id="nav-profile" role="tabpanel"
                                            aria-labelledby="nav-profile-tab">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.address') }} : {{ $getorderdata->shipping_address }}
                                                </li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.landmark') }} :
                                                    {{ $getorderdata->shipping_landmark }} </li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.postalcode') }} :
                                                    {{ $getorderdata->shipping_postal_code }}</li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.city') }} : {{ $getorderdata->shipping_city }}</li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.state') }} : {{ $getorderdata->shipping_state }}</li>
                                                <li class="list-group-item d-flex align-items-center">
                                                    {{ trans('labels.country') }} : {{ $getorderdata->shipping_country }}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-7 col-xl-8">
            <div class="row">
                <div class="col-md-12 my-2 d-flex justify-content-end">
                    <a href="{{ URL::to('admin/orders/print/' . $getorderdata->order_number) }}"
                        class="btn btn-info mx-1 {{ Auth::user()->type == 1 ? 'disabled' : '' }}">
                        <i class="fa fa-pdf" aria-hidden="true"></i> {{ trans('labels.print') }}
                    </a>
                    <button type="button"
                        class="btn btn-sm btn-dark {{ session()->get('direction') == 2 ? 'dropdown-toggle-rtl' : 'dropdown-toggle' }} {{ Auth::user()->type == 1 ? 'disabled' : '' }}"
                        data-bs-toggle="dropdown">{{ trans('labels.action') }}</button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item w-auto @if ($getorderdata->status == '1') fw-600 @endif"
                            onclick="statusupdate('{{ URL::to('admin/orders/update-' . $getorderdata->id . '-2') }}')">{{ trans('labels.accept') }}</a>
                        <a class="dropdown-item w-auto @if ($getorderdata->status == '2') fw-600 @endif"
                            onclick="statusupdate('{{ URL::to('admin/orders/update-' . $getorderdata->id . '-5') }}')">{{ trans('labels.complete') }}</a>
                        <a class="dropdown-item w-auto"
                            onclick="statusupdate('{{ URL::to('admin/orders/update-' . $getorderdata->id . '-3') }}')">{{ trans('labels.reject') }}</a>
                    </div>
                    <a href="{{ URL::to('/admin/orders/generatepdf/' . $getorderdata->order_number) }}" tooltip="{{trans('labels.downloadpdf')}}"
                        class="btn btn-secondary mx-1"><i class="fa-solid fa-file-pdf"></i></a>
                </div>
               
            </div>
            <div class="card border-0 mb-3">
                <div class="card-body">
                    <div class="progress-barrr">
                        @if (!in_array($getorderdata->status, [1, 2, 3, 4, 5]))
                            <div
                                class="{{ session()->get('direction') == 2 ? 'progress-step-rtl' : 'progress-step' }} is-active">
                                <div class="step-count"><i class="fa-regular fa-exclamation-triangle"></i></div>
                                <div class="step-description">{{ trans('messages.wrong') }}</div>
                            </div>
                        @else
                            <div
                                class="{{ session()->get('direction') == 2 ? 'progress-step-rtl' : 'progress-step' }} @if ($getorderdata->status == '1') is-active @endif">
                                <div class="step-count"><i class="fa-regular fa-bell"></i></div>
                                <div class="step-description">{{ trans('labels.placed') }}</div>
                            </div>
                            @if (in_array($getorderdata->status, [3, 4]))
                                <div
                                    class="{{ session()->get('direction') == 2 ? 'progress-step-rtl' : 'progress-step' }} is-active">
                                    <div class="step-count"><i class="fa-regular fa-close"></i></div>
                                    <div class="step-description">
                                        {{ $getorderdata->status == 3 ? trans('labels.cancelled_by_admin') : trans('labels.cancelled_by_you') }}
                                    </div>
                                </div>
                            @else
                                <div
                                    class="{{ session()->get('direction') == 2 ? 'progress-step-rtl' : 'progress-step' }} @if ($getorderdata->status == '2') is-active @endif">
                                    <div class="step-count"><i class="fa-regular fa-tasks"></i></div>
                                    <div class="step-description">{{ trans('labels.preparing') }}</div>
                                </div>
                            @endif
                            <div
                                class="{{ session()->get('direction') == 2 ? 'progress-step-rtl' : 'progress-step' }} @if ($getorderdata->status == '5') is-active @endif">
                                <div class="step-count"><i class="fa-regular fa-check"></i></div>
                                <div class="step-description">{{ trans('labels.delivered') }}</div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="card border-0 mb-3">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr class="text-uppercase">
                                    <td>{{ trans('labels.image') }}</td>
                                    <td>{{ trans('labels.products') }}</td>
                                    <td class="text-end">{{ trans('labels.unit_cost') }}</td>
                                    <td class="text-end">{{ trans('labels.qty') }}</td>
                                    <td class="text-end">{{ trans('labels.sub_total') }}</td>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($ordersdetails as $orders)
                                    <tr>
                                        <td><img src="{{ helper::image_path($orders->product_image) }}"
                                                class="rounded hw-50" alt=""></td>
                                        <td>{{ $orders->product_name }}
                                            @if ($orders->variation_id > 0)
                                                <br><small> {{ $orders->attribute }} :
                                                    <b>{{ $orders->variation_name }}</b> </small>
                                            @endif
                                        </td>
                                        <td class="text-end">
                                            {{ helper::currency_formate($orders->product_price, $orders->vendor_id) }}
                                        </td>
                                        <td class="text-end">{{ $orders->qty }}</td>
                                        <td class="text-end">
                                            {{ helper::currency_formate($orders->product_price * $orders->qty, $orders->vendor_id) }}
                                        </td>
                                    </tr>
                                @endforeach
                                <tr>
                                    <td class="text-end" colspan="4">
                                        <strong>{{ trans('labels.sub_total') }}</strong>
                                    </td>
                                    <td class="text-end">
                                        <strong>{{ helper::currency_formate($getorderdata->sub_total, $getorderdata->vendor_id) }}</strong>
                                    </td>
                                </tr>
                                @if ($getorderdata->offer_amount > 0)
                                    <tr>
                                        <td class="text-end" colspan="4">
                                            <strong>{{ trans('labels.discount') }}</strong>{{ $getorderdata->offer_code != '' ? '(' . $getorderdata->offer_code . ')' : '' }}
                                        </td>
                                        <td class="text-end">
                                            <strong>{{ helper::currency_formate($getorderdata->offer_amount, $getorderdata->vendor_id) }}</strong>
                                        </td>
                                    </tr>
                                @endif
                                <tr>
                                    <td class="text-end" colspan="4">
                                        <strong>{{ trans('labels.tax') }}</strong>
                                    </td>
                                    <td class="text-end">
                                        <strong>{{ helper::currency_formate($getorderdata->tax_amount, $getorderdata->vendor_id) }}</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-end" colspan="4">
                                        <strong>{{ trans('labels.delivery_charge') }}</strong>
                                    </td>
                                    <td class="text-end">
                                        <strong>{{ helper::currency_formate($getorderdata->delivery_charge, $getorderdata->vendor_id) }}</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-end text-success" colspan="4">
                                        <strong>{{trans('labels.total')}} {{ trans('labels.amount') }}</strong>
                                    </td>
                                    <td class="text-end text-success">
                                        <strong>{{ helper::currency_formate($getorderdata->grand_total, $getorderdata->vendor_id) }}</strong>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
