@extends('web.layout.default')

@section('contents')

    <section class="py-5 mb-5 bg-light">

        <div class="container">

            <nav aria-label="breadcrumb">

                <h2 class="breadcrumb-title mb-2">{{ trans('labels.categories') }}</h2>

                <ol class="breadcrumb justify-content-center">

                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : ' breadcrumb-item ' }}"><a class="text-dark" href="{{ URL::to(@$vendordata->slug . '/')}}">{{ trans('labels.home') }}</a></li>

                    <li class="text-muted {{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : ' breadcrumb-item ' }} active" aria-current="page">{{ trans('labels.categories') }}</li>

                </ol>

            </nav>

        </div>

    </section>

    <section class="py-3">

        <div class="container">

            {{-- <h4 class="inner-title mb-4">Categories</h4> --}}

            <div class="categorywrapper row align-items-baseline justify-content-sm-start justify-content-center">

                @forelse (helper::getcategories(@$vendordata->id,"") as $category)

                    <a href="{{ URL::to(@$vendordata->slug . '/category?category='.$category->slug)}}" class="category">

                        <div class="text-center mb-3">

                            <img src="{{helper::image_path($category->image)}}" alt="" srcset="">

                            <p class="fs-7 text-truncate">{{ ucfirst($category->name) }}</p>
                            
                        </div>

                    </a>

                @empty

                    @include('web.nodata')

                @endforelse

            </div>

        </div>

    </section>

@endsection