<!-- top bar section start -->
<section class="top-bar bg-dark py-1 d-md-block d-none">
    <div class="container">
        <div class="d-flex align-items-center justify-content-between">
            <div class="top-bar-call-email d-none d-md-block text-white">
                <a href="tel:{{ helper::appdata($vendordata->id)->contact }}" class="text-white"><i class="fa-light fa-phone mx-1"></i>{{ helper::appdata(@$vendordata->id)->contact }}</a> |
                <a href="mailto:{{ helper::appdata($vendordata->id)->email }}" class="text-white"><i class="fa-regular fa-envelope mx-1"></i>{{ helper::appdata(@$vendordata->id)->email }}</a>
            </div>

            <!-- lag btn for deckstop start-->
            <div class="d-flex align-items-center">
                <ul class="topbar-social-media mx-2 d-none d-md-block">
                    <li class="d-flex gap-3">
                        @if (helper::appdata($vendordata->id)->facebook_link != null || helper::appdata($vendordata->id)->facebook_link != '')
                        <a href="{{ helper::appdata($vendordata->id)->facebook_link }}"><i class="fa-brands fa-facebook "></i></a>
                        @endif
                        @if (helper::appdata($vendordata->id)->twitter_link != null || helper::appdata($vendordata->id)->twitter_link != '')
                        <a href="{{ helper::appdata($vendordata->id)->twitter_link }}"><i class="fa-brands fa-twitter "></i></a>
                        @endif
                        @if (helper::appdata($vendordata->id)->instagram_link != null || helper::appdata($vendordata->id)->instagram_link != '')
                        <a href="{{ helper::appdata($vendordata->id)->instagram_link }}"><i class="fa-brands fa-instagram "></i></a>
                        @endif
                        @if (helper::appdata($vendordata->id)->linkedin_link != null || helper::appdata($vendordata->id)->linkedin_link != '')
                        <a href="{{ helper::appdata($vendordata->id)->linkedin_link }}"><i class="fa-brands fa-linkedin "></i></a>
                        @endif
                    </li>
                </ul>
                @if (App\Models\SystemAddons::where('unique_identifier', 'language')->first() != null &&
                App\Models\SystemAddons::where('unique_identifier', 'language')->first()->activated == 1)
                <div class="d-lg-block d-none">
                    <div class="lag-btn dropdown border-0 shadow-none">
                        <button class="btn dropdown-toggle language-dropdown d-flex justify-content-between align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="{{ helper::image_path(session()->get('flag')) }}" class="lag-img img-fluid mx-1" alt="">
                        </button>
                        <ul class="dropdown-menu rounded-1 p-0 rounded-3 overflow-hidden">
                            @foreach (helper::listoflanguage() as $languagelist)
                            <li><a class="dropdown-item text-dark d-flex align-items-center text-left px-3 py-2" href="{{ URL::to('/lang/change?lang=' . $languagelist->code) }}">
                                    <img src="{{ helper::image_path($languagelist->image) }}" alt="" class="img-fluid lag-img mx-1 w-25">
                                    &nbsp;&nbsp;{{ $languagelist->name }}
                                </a>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                @endif
            </div>
            <!-- lag btn for deckstop end-->

            <div class="search-box d-block d-md-none">
                <div class="search d-flex align-items-center">
                    <a type="button" class="btn btn-primary bg-transparent border-0 px-0 nav-icon-m-1 mx-1" data-bs-toggle="modal" data-bs-target="#searchModal">
                        <i class="fa-light fa-magnifying-glass text-white fs-25-px"></i>
                    </a>
                    <!-- mobile-login section -->
                    <div class="mobile-login d-block d-md-none">
                        <ul class="right-btn-wrapper d-flex align-items-center {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'right-btn-wrapper-rtl' : '' }}">

                            <li class="shopping-cart d-block d-md-none"><a href="{{ URL::to(@$vendordata->slug . '/cart') }}" class="cart-dropdown-btn"><span class="cart-count text-white">{{ helper::getcartcount(@$vendordata->id, session()->getId(), Auth::user() && Auth::user()->type == 3 ? Auth::user()->id : '') }}</span><i class="fa-light fa-bag-shopping text-white mx-1 fs-25-px"></i></a>
                            </li>
                            @if (Auth::user() && Auth::user()->type == 3)
                            <li class="m-1 d-block d-md-none">
                                <div class="dropdown p-0">
                                    <div class="d-flex align-items-center">
                                        <div>
                                            <a href="{{ URL::to($vendordata->slug . '/profile') }}" class="border-0 dropdown-toggle text-dark d-flex align-items-center" type="button">
                                                <i class="fa-light fa-user text-white mx-2 fs-25-px"></i>
                                            </a>
                                        </div>
                                    </div>

                                </div>
                            </li>
                            @else
                            @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                            App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                            @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                            <li class="m-1">
                                <a href="{{ URL::to($vendordata->slug . '/login') }}" class="text-white d-flex align-items-center">
                                    <i class="fa-light fa-user text-white mx-2 fs-25-px"></i>
                                    <span class="d-none d-md-block mx-1">{{ trans('labels.login') }}</span></a>
                            </li>
                            @endif
                            @endif
                            @endif
                        </ul>
                    </div>
                    <!-- mobile-login section -->
                </div>
            </div>
        </div>
</section>

<!-- top bar section end -->

<!-- NAVBAR AREA START -->

<!-- FOR LARGE DEVICES -->

<section class="navbar-area border-bottom sticky-top">

    <div class="container">

        <div class="row align-items-center justify-content-between">

            <div class="col-xl-2 col-lg-2 col-md-4 col-7">

                <div class="logo-wrapper navbar-brand py-2">

                    <a href="{{ URL::to(@$vendordata->slug . '/') }}">

                        <img src="{{ helper::image_path(@helper::appdata(@$vendordata->id)->logo) }}" class="my-2 logo-h-45-px header-logo" alt="logo">

                    </a>

                </div>

            </div>

            <div class="col-xl-8 col-lg-8 col-md-4 d-none d-xl-block">

                @include('web.layout.common_menulist')

            </div>

            <div class="col-xl-2 col-lg-2 col-md-5 col-5">
                <!-- Modal -->
                <div class="modal fade" id="subsciptionmodal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered">
                        <div class="modal-content bg-lights">
                            <div class="modal-body p-md-0">
                                <div class="row align-items-center justify-content-around">
                                    <div class="card rounded-4 border-0 bg-lights p-md-4">
                                        <div class="d-flex justify-content-end">
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="row align-items-center justify-content-between">
                                            <div class="col-6 d-none d-lg-block">
                                                <img src="{{ helper::image_path(helper::appdata($vendordata->id)->subscribe_image) }}" alt="" class="w-100 object-fit-cover rounded-4">
                                            </div>

                                            <div class="col-lg-6 col-12">
                                                <h2 class="subscribe-title">{{ trans('labels.subscribe_title') }}
                                                </h2>
                                                <p class="text-dark fw-normal mb-4">
                                                    {{ trans('labels.subscribe_subtitle') }}
                                                </p>
                                                <form action="{{ URL::to($vendordata->slug . '/subscribe') }}" method="post">
                                                    @csrf
                                                    <div class="input-group mb-4">
                                                        <input type="text" class="form-control border text-dark fw-500 rounded-0 bg-light" name="subscribe_email" placeholder="{{ trans('labels.email') }}" required="">
                                                    </div>
                                                    <button type="submit" class="btn btn-fashion w-100" id="basic-addon2">{{ trans('labels.subscribe') }}</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex align-items-center {{ session()->get('direction') == 2 ? 'float-start' : 'float-end' }}">
                    <div class="search-box d-none d-lg-block">
                        <!-- Button trigger modal -->
                        <a type="button" class="btn px-0 border-0 nav-icon-m-1 mx-1" data-bs-toggle="modal" data-bs-target="#searchModal">
                            <i class="fa-light fa-magnifying-glass text-dark mx-1 fs-25-px"></i>
                        </a>
                    </div>


                    <!-- Modal -->
                    <div class="modal fade" id="searchModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-xl modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header border-0">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form class="" action="{{ URL::to(@$vendordata->slug . '/products') }}" method="GET">
                                        <div class="col-12">
                                            <div class="row align-items-center justify-content-between">
                                                <div class="col-6 d-none d-lg-block">
                                                    <div class="Search-left-img">
                                                        <img src="{{ url(env('ASSETPATHURL') . 'web-assets/images/other/Search-left-img.png') }}" alt="search-left-img" class="w-100 object-fit-cover search-left-img">
                                                    </div>
                                                </div>

                                                <div class="col-12 col-lg-6">
                                                    <div class="search-content text-capitalize">
                                                        <h4 class="fs-1 text-dark fw-bolder mb-2">
                                                            {{ trans('labels.search') }}
                                                        </h4>
                                                        <p class="fs-3">what are you looking for ?</p>
                                                    </div>
                                                    <input type="text" placeholder="Search Product..." class="py-3 input-width px-2 mt-4 mb-1" name="name" value="{{ isset($_GET['name']) ? $_GET['name'] : '' }}" required>
                                                    <p class="text-truncate">Ex.accessories, man, dresses, etc...
                                                    </p>
                                                    <div class="search-btn-group">
                                                        <div class="row align-items-center mt-sm-5 mt-4">
                                                            <div class="col-lg-5 col-6">
                                                                <button type="button" class="btn btn-danger w-100 rounded-0 py-3 rounded-1" data-bs-dismiss="modal">{{ trans('labels.cancel') }}</button>
                                                            </div>
                                                            <div class="col-lg-5 col-6">
                                                                <button type="submit" class="btn btn-secondary w-100 rounded-0 py-3 rounded-1">{{ trans('labels.submit') }}</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <ul class="right-btn-wrapper {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'right-btn-wrapper-rtl' : '' }}">

                        <li class="shopping-cart d-none d-lg-block"><a href="{{ URL::to(@$vendordata->slug . '/cart') }}" class="cart-dropdown-btn"><span class="cart-count text-white">{{ helper::getcartcount(@$vendordata->id, session()->getId(), Auth::user() && Auth::user()->type == 3 ? Auth::user()->id : '') }}</span><i class="fa-light fa-bag-shopping mx-1 text-dark fs-25-px"></i></a>
                        </li>

                        @if (Auth::user() && Auth::user()->type == 3)
                        <li class="m-1 d-none d-lg-block">
                            <div class="dropdown p-0">
                                <div class="d-flex align-items-center">
                                    <div>
                                        <a href="{{ URL::to($vendordata->slug . '/profile') }}" class="border-0 dropdown-toggle text-dark d-flex align-items-center" type="button">
                                            <i class="fa-light fa-user text-dark mx-2 fs-25-px"></i>
                                        </a>

                                    </div>
                                </div>

                            </div>
                        </li>
                        @else
                        @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                        App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                        @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                        <li class="m-1 d-none d-lg-block">
                            <a href="{{ URL::to($vendordata->slug . '/login') }}" class="text-white d-flex align-items-center">
                                <i class="fa-light fa-user text-dark mx-2 fs-25-px"></i></a>
                        </li>
                        @endif
                        @endif
                        @endif

                        <!-- FOR SMALL DEVICE TOP CATEGORIES -->
                        @if (App\Models\SystemAddons::where('unique_identifier', 'language')->first() != null &&
                        App\Models\SystemAddons::where('unique_identifier', 'language')->first()->activated == 1)
                        <div class="d-lg-none mx-sm-0 mx-1">

                            <div class="lag-btn dropdown border-0 shadow-none">
                                <button class="btn dropdown-toggle language-dropdown d-flex justify-content-between align-items-center" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <img src="{{ helper::image_path(session()->get('flag')) }}" class="lag-img-mobile img-fluid" alt="">
                                </button>
                                <ul class="dropdown-menu rounded-1 p-0 rounded-3 overflow-hidden">
                                    @foreach (helper::listoflanguage() as $languagelist)
                                    <li><a class="dropdown-item text-dark d-flex align-items-center text-left px-0 py-2" href="{{ URL::to('/lang/change?lang=' . $languagelist->code) }}">
                                            <img src="{{ helper::image_path($languagelist->image) }}" alt="" class="img-fluid lag-img-mobile mx-1 w-25">
                                            &nbsp;&nbsp;{{ $languagelist->name }}
                                        </a>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        @endif



                        <div class="offcanvas offcanvas-width  {{ session()->get('direction') == 2 ? 'offcanvas-end' : 'offcanvas-start' }}" data-bs-scroll="false" tabindex="-1" id="top-categories" aria-labelledby="offcanvasWithBothOptionsLabel">
                            <div class="offcanvas-header">
                                <button type="button" class="btn-close ms-auto" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                            </div>
                            <div class="offcanvas-body">
                                @if (count(helper::getcategories(@$vendordata->id, '')) > 0)
                                <ul class="list-group list-group-flush">
                                    @foreach (helper::getcategories(@$vendordata->id, '') as $categorydata)
                                    <li class="list-group-item px-0">
                                        <a class="d-flex align-items-center" href="{{ URL::to(@$vendordata->slug . '/category?category=' . $categorydata['slug']) }}">
                                            <img src="{{ helper::image_path($categorydata->image) }}" alt="" class="img-fluid rounded categories-sm-img">
                                            <span class="mx-2 text-dark text-truncate">{{ $categorydata['name'] }}</span>
                                        </a>
                                    </li>
                                    @endforeach
                                </ul>
                                @endif
                            </div>
                        </div>
                        <!-- FOR SMALL DEVICE TOP CATEGORIES -->

                        <!-- FOR SMALL SIDE BAR DEVICES -->

                        <li class="d-block d-xl-none">
                            <a class="btn bg-primary hamburger" type="button" data-bs-toggle="offcanvas" data-bs-target="#common-slidebar" aria-controls="offcanvasRight">
                                <i class="fa-regular fa-bars text-white  fs-25-px"></i>
                            </a>
                        </li>

                        <!-- FOR SMALL SIDE BAR DEVICES -->
                    </ul>
                </div>

            </div>

        </div>

    </div>

    <!-- pro-view Modal -->
    <div class="modal fade" id="pro-view" tabindex="-1" aria-labelledby="pro-view" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="d-flex justify-content-end mb-3">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <section class="product-view p-0">
                        <div class="row justify-content-between">
                            <div class="col-lg-6">

                                <div id="carouseltest" class="carousel slide">
                                    <div class="carousel-inner"></div>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="product-content px-md-0">
                                    <div class="card border-0 h-600">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <h2 class="text-dark product-title product-line"></h2>
                                            </div>
                                            <!-- rating star section Start -->
                                            @if (App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first() != null &&
                                            App\Models\SystemAddons::where('unique_identifier', 'customer_login')->first()->activated == 1)
                                            @if (helper::appdata($vendordata->id)->checkout_login_required == 1)
                                            <div class="d-flex">
                                                <p class="fs-6"><i class="text-warning fa-solid fa-star {{ session()->get('direction') == 2 ? 'ps-1' : 'pe-1' }}"></i>
                                                    <span class="text-dark fw-500 average_rating"></span>
                                                </p>
                                                <span class="px-2 d-inline-block text-dark fw-500 total-ratting">(
                                                    {{ trans('labels.ratting') }})</span>
                                            </div>
                                            @endif
                                            @endif

                                            <!-- rating star section End -->
                                            <p class="pt-2">
                                                <span class="product-price" id="modal_product_price"></span>
                                                <del class="text-muted fs-7 product-original-price" id="modal_product-original-price"></del>
                                                <span class="text-secondary product-price-off-box px-2">(<span class="price-off" id="modal_price-off">12</span>)
                                                </span>
                                            </p>
                                            <p>
                                                <span class="text-danger"><span class="additional_tax" id="modal_additional_tax"></span>%
                                                    {{ trans('labels.additional_tax') }}</span>
                                            </p>

                                            <div class="variation d-flex mt-2">
                                                <p class="text-primary me-2"> {{ trans('labels.size') }} </p> : <span class="modal-product-variation fw-600"></span>
                                            </div>



                                            <div class="row mt-2">
                                                <p class="text-primary fw-semibold mb-1">
                                                    {{ trans('labels.product_details') }}
                                                </p>
                                                <div class="col-lg-12 line-5">
                                                </div>
                                            </div>


                                            <div class="row my-3 modal-product-variation">
                                                <p class="text-primary fw-semibold mb-1">
                                                    {{ trans('labels.select_attribute') }} <span class="attribute"></span>
                                                </p>
                                                <div class="col-lg-12">
                                                    <ul class="d-flex align-items-center gap-2 multivariants">
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="row align-items-center justify-content-between">
                                            <div class="col-lg-6 col-md-6 col-12 mb-3 mb-md-0">
                                                <a href="javascript:void(0)" class="btn btn-lg btn-fashion w-100" id="modal-addtocart">{{ trans('labels.add_to_cart') }}</a>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <a href="" class="btn btn-lg btn-primary rounded-0 w-100 fs-6" id="full_view">{{ trans('labels.full_view') }}</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>
    <!-- pro-view Modal -->


    <div class="mobile-menu-footer  d-lg-none">
        <ul class="d-flex align-items-center mobile-menu-active p-0 m-0">
            <li class="position-relative">
                <a class="{{ request()->is($vendordata->slug) ? 'active' : '' }}" href="{{ URL::to(@$vendordata->slug . '/') }}">
                    <i class="fa-light fa-house"></i>
                    <span class="tab-bar-text">{{ trans('labels.home') }}</span>
                </a>
            </li>
            <li class="position-relative">
                <a href="javascript:void(0)" class="{{ request()->is($vendordata->slug . '/products') ? 'active' : '' }}" data-bs-toggle="modal" data-bs-target="#searchModal">
                    <i class="fa-light fa-search"></i>
                    <span class="tab-bar-text">{{ trans('labels.search') }}</span>
                </a>
            </li>
            <li class="position-relative">
                <a class="{{ request()->is($vendordata->slug . '/categories') ? 'active' : '' }}" href="{{ URL::to(@$vendordata->slug . '/categories') }}" type="button">
                    <i class="fa-light fa-box-archive"></i>
                    <span class="tab-bar-text">{{ trans('labels.categories') }}</span>
                </a>
            </li>
            <li class="position-relative">
                <a class="{{ request()->is($vendordata->slug . '/cart') ? 'active' : '' }}" href="{{ URL::to(@$vendordata->slug . '/cart') }}" class="">
                    <i class="fa-light fa-bag-shopping position-relative">
                        <span class="cart-count cart-mobile text-white p-0">{{ helper::getcartcount(@$vendordata->id, session()->getId(), Auth::user() && Auth::user()->type == 3 ? Auth::user()->id : '') }}</span>
                    </i>
                    <span class="tab-bar-text">{{ trans('labels.cart') }}</span>
                </a>
            </li>

            
            <li class="position-relative">
                <a class="{{ request()->is($vendordata->slug . '/profile') ? 'active' : '' }}" href="{{Auth::user() && Auth::user()->type == 3 ? URL::to($vendordata->slug . '/profile'): URL::to($vendordata->slug . '/login') }}" class="togl-btn text-dark toggle_button">
                    <i class="fa-light fa-user fs-6"></i>
                    <span class="tab-bar-text">{{ trans('labels.account') }}</span>
                </a>
            </li>
        </ul>
    </div>
</section>
@if (helper::appdata('')->cookie_recaptcha == 1)
@include('cookie-consent::index')
@endif