@extends('web.layout.default')
@section('contents')
    <!-- BREADCRUMB AREA START -->
    <section class="py-5 mb-5 bg-light">
        <div class="container">
            <nav aria-label="breadcrumb">
                <h2 class="breadcrumb-title mb-2">{{ trans('labels.order_details') }}</h2>
                <ol class="breadcrumb justify-content-center">
                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : ' breadcrumb-item ' }}"><a
                            class="text-dark" href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                    </li>
                    <li class="text-muted {{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : ' breadcrumb-item ' }} active"
                        aria-current="page">{{ trans('labels.order_details') }}</li>
                </ol>
            </nav>
        </div>
    </section>
    <!-- BREADCRUMB AREA END -->

    <section class="order_detail py-3">
        <div class="container">
            @if($order_number == "")
            <div class="row align-items-center justify-content-between mb-5">
                <div class="col-lg-6">
                    <img src="{{helper::image_path(helper::appdata($vendordata->id)->order_detail_image)}}"
                        class="w-100 mb-5 mb-lg-0" alt="tracking">
                </div>
                <div class="col-lg-6 col-xl-5">
                    <h2 class="track-title text-truncate">{{ trans('labels.find_order_title') }}</h2>
                    <p class="track-description mb-4 line-3">{{ trans('labels.find_order_subtitle') }}</p>
                    <form action="{{ URL::to(@$vendordata->slug . '/find-order') }}" method="get">
                        <label class="form-label">{{ trans('labels.order_id') }}</label>
                        <div class="input-group mb-4">
                            <input type="text"
                                class="form-control rounded-0 bg-transparent input-h {{ session()->get('direction') == 2 ? 'ms-2' : 'me-2' }}"
                                name="order" value="{{ $order_number }}"
                                placeholder="{{ trans('labels.find_order_placeholder') }}">
                        </div>
                        <button class="btn btn-fashion" type="submit">{{ trans('labels.track_here') }}</button>
                    </form>
                </div>
            </div>
            @endif
            @if (!empty($getorderdata))
                <div class="row gx-0 justify-content-between align-items-end">
                    <div class="card border-0 rounded-0 bg-light">
                        <div class="card-body">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-12 col-md-8 col-lg-8 col-xl-6">
                                    <div class="d-md-flex justify-content-between">
                                        <div>
                                            <div class="d-flex align-items-center justify-contente-between py-2">
                                                <span class="text-dark fw-bold">{{trans('labels.order_id')}} :&nbsp;</span>
                                                <div class="fw-bold text-secondary">#{{ $getorderdata->order_number }}</div>
                                            </div>
                                            <div class="d-flex align-items-center justify-contente-between py-2">
                                                <span class="text-dark fw-bold">{{trans('labels.order_date')}} :&nbsp;</span>
                                                <p
                                                    class=" {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'ms-auto' : 'me-auto' }} ">
                                                    {{ helper::date_formate($getorderdata->created_at) }}</p>
                                            </div>
                                        </div>
                                        <div class="px-md-4">
                                            <div class="d-flex align-items-center justify-contente-between py-2">
                                                <span class="text-dark fw-bold">{{ trans('labels.order_status') }} :&nbsp;</span>
                                                <p>
                                                    @if ($getorderdata->status == 1)
                                                        {{ trans('labels.order_placed') }}
                                                    @elseif($getorderdata->status == 2)
                                                        {{ trans('labels.preparing') }}
                                                    @elseif($getorderdata->status == 3)
                                                        {{ trans('labels.cancelled_by_admin') }}
                                                    @elseif($getorderdata->status == 4)
                                                        {{ trans('labels.cancelled_by_you') }}
                                                    @elseif($getorderdata->status == 5)
                                                        {{ trans('labels.delivered') }}
                                                    @endif
                                                </p>
                                            </div>
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item d-flex px-0 bg-light border-bottom-0">
                                                    <span class="text-dark fw-bold">{{ trans('labels.payment_type') }}
                                                        :&nbsp;</span>
                                                    <span class="text-muted">
                                                        {{ @helper::getpayment($getorderdata->transaction_type,Auth::user()->id)->payment_name }} 
                                                    </span>
                                                </li>
                                                @if ($getorderdata->transaction_type != '1' && $getorderdata->transaction_type != '6')
                                                    <li class="list-group-item d-flex px-0 bg-light">
                                                        <strong>{{ trans('labels.payment_id') }} :&nbsp;</strong>
                                                        <span>{{ $getorderdata->transaction_id }}</span>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-4 col-lg-3 col-xl-2">
                                    @if ($getorderdata->status == 1)
                                        <a class="btn btn-danger text-white btn-outline-danger fw-500 {{ session()->get('direction') == 2 ? 'float-start' : 'float-end' }}"
                                            href="javascript:void(0)"
                                            onclick="cancelorder('{{ URL::to(@$vendordata->slug . '/orders-cancel-' . $getorderdata->order_number) }}')">{{ trans('labels.cancel_order') }}
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="row justify-content-between mb-4">
                            <div class="col-md-4 mb-3 mb-md-0 text-start">
                                <div class="card border-0 bg-light rounded-0 h-100">
                                    <div class="card-body">
                                        <span class="text-dark fw-bold"> {{ trans('labels.sold_by') }} : </span>
                                        <p class="fs-7">{{ @$vendordata->name }}</p>
                                        <p class="fs-7">{{ @helper::appdata(@$vendordata->id)->mobile }}</p>
                                        <p class="fs-7">{{ @helper::appdata(@$vendordata->id)->email }}</p>
                                        <p class="fs-7">{{ @helper::appdata(@$vendordata->id)->address }}</p>
                                    </div>
                                </div>
                            </div>
                            <div
                                class="col-md-4 mb-3 mb-md-0 {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'text-end' : 'text-start' }}">
                                <div class="card border-0 bg-light rounded-0 h-100">
                                    <div class="card-body">
                                        <span class="text-dark fw-bold"> {{ trans('labels.billing_address') }} : </span>
                                        <p class="fs-7">{{ trans('labels.address') }} :
                                            {{ $getorderdata->billing_address }}</p>
                                        <p class="fs-7">{{ trans('labels.landmark') }} :
                                            {{ $getorderdata->billing_landmark }}
                                        </p>
                                        <p class="fs-7">{{ trans('labels.postalcode') }} :
                                            {{ $getorderdata->billing_postal_code }}</p>
                                        <p class="fs-7">{{ trans('labels.city') }} : {{ $getorderdata->billing_city }}
                                        </p>
                                        <p class="fs-7">{{ trans('labels.state') }} : {{ $getorderdata->billing_state }}
                                        </p>
                                        <p class="fs-7">{{ trans('labels.country') }} :
                                            {{ $getorderdata->billing_country }}</p>
                                    </div>
                                </div>
                            </div>
                            <div
                                class="col-md-4 {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'text-end' : 'text-start' }}">
                                <div class="card border-0 bg-light rounded-0 h-100">
                                    <div class="card-body">
                                        <span class="text-dark fw-bold"> {{ trans('labels.shipping_address') }} : </span>
                                        <p class="fs-7">{{ trans('labels.address') }} :
                                            {{ $getorderdata->shipping_address }}
                                        </p>
                                        <p class="fs-7">{{ trans('labels.landmark') }} :
                                            {{ $getorderdata->shipping_landmark }}
                                        </p>
                                        <p class="fs-7">{{ trans('labels.postalcode') }} :
                                            {{ $getorderdata->shipping_postal_code }} </p>
                                        <p class="fs-7">{{ trans('labels.city') }} : {{ $getorderdata->shipping_city }}
                                        </p>
                                        <p class="fs-7">{{ trans('labels.state') }} :
                                            {{ $getorderdata->shipping_state }}</p>
                                        <p class="fs-7">{{ trans('labels.country') }} :
                                            {{ $getorderdata->shipping_country }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <div class="col-md-12 col-lg-7 col-xl-8 mb-4 mb-lg-0">
                                <div class="card border-0 bg-light rounded-0">
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <thead>
                                                    <tr class="text-uppercase fs-7">
                                                        <td>{{ trans('labels.image') }}</td>
                                                        <td>{{ trans('labels.product') }}</td>
                                                        <td>{{ trans('labels.unit_cost') }}</td>
                                                        <td>{{ trans('labels.qty') }}</td>
                                                        <td>{{ trans('labels.sub_total') }}</td>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($getorderitemlist as $product)
                                                        <tr class="align-middle">
                                                            <td><img src="{{ helper::image_path($product->product_image) }}"
                                                                    class="object-fit-cover rounded hw-70-px"> </td>
                                                            <td>
                                                                <p> {{ $product->product_name }} </p>
                                                                @if ($product->variation_id > 0)
                                                                    <p><small> {{ ucfirst($product->attribute) }} :
                                                                            <b>{{ ucfirst($product->variation_name) }}</b></small>
                                                                    </p>
                                                                @endif
                                                            </td>
                                                            <td>{{ helper::currency_formate($product->product_price, $product->vendor_id) }}
                                                            </td>
                                                            <td>{{ $product->qty }}</td>
                                                            <td> {{ helper::currency_formate($product->product_price * $product->qty, $product->vendor_id) }}
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-12">
                                <div class="card bg-light border-0 rounded-0">
                                    <div class="card-body">
                                        <ul class="list-group list-group-flush mb-3">
                                            <li
                                                class="list-group-item d-flex justify-content-between px-0 border-0 bg-light">
                                                <strong>{{ trans('labels.sub_total') }}</strong>
                                                <span>{{ helper::currency_formate($getorderdata->sub_total, $getorderdata->vendor_id) }}</span>
                                            </li>
                                            <li
                                                class="list-group-item d-flex justify-content-between px-0 border-0 bg-light">
                                                <strong>{{ trans('labels.discount') }}
                                                    {{ $getorderdata->offer_code != '' ? '(' . $getorderdata->offer_code . ')' : '' }}
                                                </strong>
                                                <span>{{ helper::currency_formate($getorderdata->offer_amount, $getorderdata->vendor_id) }}</span>
                                            </li>
                                            <li
                                                class="list-group-item d-flex justify-content-between px-0 border-0 bg-light">
                                                <strong>{{ trans('labels.tax') }}</strong>
                                                <span>{{ helper::currency_formate($getorderdata->tax_amount, $getorderdata->vendor_id) }}</span>
                                            </li>
                                            <li
                                                class="list-group-item d-flex justify-content-between px-0 border-0 bg-light">
                                                <strong>{{ trans('labels.delivery_charge') }}</strong>
                                                <span>{{ helper::currency_formate($getorderdata->delivery_charge, $getorderdata->vendor_id) }}</span>
                                            </li>
                                            <li
                                                class="list-group-item d-flex justify-content-between px-0 border-0 border-top-dashed text-secondary bg-light">
                                                <strong>{{ trans('labels.grand_total') }}</strong>
                                                <strong>{{ helper::currency_formate($getorderdata->grand_total, $getorderdata->vendor_id) }}</strong>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @else
            @endif
        </div>
    </section>
    <!-- ORDER DETAILS AREA END -->
@endsection
@section('scripts')
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/orders.js') }}"></script>
@endsection
