@extends('web.layout.default')
@section('contents')
    <section class="py-5 mb-5 bg-light">
        <div class="container">
            <nav aria-label="breadcrumb">

                <h2 class="breadcrumb-title mb-2">{{ trans('labels.orders') }}</h2>

                <ol class="breadcrumb justify-content-center">
                    <li class="{{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }}"><a class="text-dark" href="{{ URL::to(@$vendordata->slug . '/')}}">{{ trans('labels.home') }}</a></li>
                    <li class="text-muted {{ @helper::appdata(@$vendordata->id)->web_layout == 2 ? 'breadcrumb-item-rtl' : 'breadcrumb-item' }} active" aria-current="page">{{ trans('labels.orders') }}</li>
                </ol>
            </nav>
        </div>
    </section>
    <section>
        <div class="container py-4">
            <div class="row">
                @include('web.user.sidebar')
                <div class="col-lg-9 col-xxl-9">
                    <div class="border px-3 rounded table-box">
                        <div class='d-md-flex align-items-center py-4 table-top-box'>
                            <a href="{{ URL::to($vendordata->slug.'/orders?type=processing') }}" class="w-100">
                                <button type='button' class="btn border rounded p-3 w-100 {{ app('request')->input('type') == 'processing' ? 'border-dark text-white bg-warning' : 'border-warning text-warning bg-white'  }}">
                                    <span class='warning-icon d-flex d-flex align-items-center'>
                                        <i class="fa-regular fa-hourglass  d-flex justify-content-center align-items-center"></i>
                                        <div class='px-3'>
                                            <p class='m-0 p-0'>{{ trans('labels.preparing') }}</p>
                                            <p class='text-start-pro m-0 p-0 {{ app('request')->input('type') == 'processing' ? 'text-white' : 'text-warning'  }}'>{{ $totalprocessing }}</p>
                                        </div>
                                    </span>
                                </button>
                            </a>
                            <a href="{{ URL::to($vendordata->slug.'/orders?type=completed') }}" class="w-100 mx-3 delivered-box">
                                <button type='button' class="btn border rounded p-3 w-100 {{ app('request')->input('type') == 'completed' ? 'border-dark text-white bg-success' : 'border-success text-success bg-white'  }} my-2 my-md-">
                                    <span class='success-icon d-flex d-flex align-items-center'>
                                        <i class='fa-regular fa-circle-check d-flex justify-content-center align-items-center'>
                                        </i>
                                        <div class='px-3'>
                                            <p class='m-0 p-0'>{{ trans('labels.delivered') }}</p>
                                            <p class='text-start-pro m-0 p-0 {{ app('request')->input('type') == 'completed' ? 'text-white' : 'text-success'  }}'>{{ $totalcompleted }}</p>
                                        </div>
                                    </span>
                                </button>
                            </a>
                            <a href="{{ URL::to($vendordata->slug.'/orders?type=rejected') }}" class="w-100 rejected-box">
                                <button type='button' class="btn border rounded p-3 w-100 {{ app('request')->input('type') == 'rejected' ? 'border-dark text-white bg-danger' : 'border-danger text-danger bg-white'  }}">
                                    <span class='danger-icon d-flex d-flex align-items-center'>
                                        <i class='fa-solid fa-xmark d-flex justify-content-center align-items-center'></i>
                                        <div class='px-3'>
                                            <p class='m-0 p-0'>{{ trans('labels.rejected') }}</p>
                                            <p class='text-start-pro m-0 p-0 {{ app('request')->input('type') == 'rejected' ? 'text-white' : 'text-danger'  }}'>{{ $totalrejected }}</p>
                                        </div>
                                    </span>
                                </button>
                            </a>
                        </div>
                        <div class="table-responsive py-4">
                            <table class="table table-striped table-bordered py-3 zero-configuration w-100" id="orders">
                                <thead>
                                    <tr class="text-uppercase fs-7">
                                        <td>{{ trans('labels.srno') }}</td>
                                        <td>{{ trans('labels.order_number') }}</td>
                                        <td>{{ trans('labels.date') }}</td>
                                        <td>{{ trans('labels.grand_total') }}</td>
                                        <td>{{ trans('labels.payment_type') }}</td>
                                        <td>{{ trans('labels.status') }}</td>
                                        <td>{{ trans('labels.action') }}</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $i = 1; @endphp
                                    @foreach ($orders as $orderdata)
                                    <tr id="dataid{{ $orderdata->id }}">
                                        <td>@php echo $i++; @endphp</td>
                                        <td>{{ $orderdata->order_number }}</td>
                                        <td>{{ helper::date_formate($orderdata->created_at) }}</td>
                                        <td>{{ helper::currency_formate($orderdata->grand_total, $orderdata->vendor_id) }}</td>
                                        <td>
                                            @if ($orderdata->transaction_type == 1)
                                            {{ trans('labels.cod') }}
                                            @elseif ($orderdata->transaction_type == 2)
                                            {{ trans('labels.razorpay') }}
                                            @elseif ($orderdata->transaction_type == 3)
                                            {{ trans('labels.stripe') }}
                                            @elseif ($orderdata->transaction_type == 4)
                                            {{ trans('labels.flutterwave') }}
                                            @elseif ($orderdata->transaction_type == 5)
                                            {{ trans('labels.paystack') }}
                                            @elseif ($orderdata->transaction_type == 7)
                                            {{ trans('labels.mercadopago') }}
                                            @elseif ($orderdata->transaction_type == 8)
                                            {{ trans('labels.paypal') }}
                                            @elseif ($orderdata->transaction_type == 9)
                                                {{ trans('labels.myfatoorah') }}
                                            @elseif ($orderdata->transaction_type == 10)
                                                {{ trans('labels.toyyibpay') }}
                                            @endif
                                            @if (in_array($orderdata->transaction_type, [2, 3, 4, 5, 7, 8, 9, 10]))
                                            : {{ $orderdata->transaction_id }}
                                            @endif
                                        </td>
                                        <td>
                                            @if ($orderdata->status == '1')
                                            <span class="text-warning"> <i class="fa-regular fa-bell"></i>
                                                {{ trans('labels.placed') }}</span>
                                            @elseif($orderdata->status == '2')
                                            <span class="text-info"> <i class="fa-regular fa-tasks"></i>
                                                {{ trans('labels.preparing') }}</span>
                                            @elseif($orderdata->status == '3')
                                            <span class="text-danger"> <i class="fa-regular fa-close"></i>
                                                {{ trans('labels.cancelled_by_you') }}</span>
                                            @elseif($orderdata->status == '4')
                                            <span class="text-danger"> <i class="fa-regular fa-close"></i>
                                                {{ trans('labels.cancelled_by_user') }}</span>
                                            @elseif($orderdata->status == '5')
                                            <span class="text-success"> <i class="fa-regular fa-check"></i>
                                                {{ trans('labels.delivered') }}</span>
                                            @else
                                            --
                                            @endif
                                        </td>
                                        <td>
                                            <a class="btn btn-sm btn-info eye-icon-box " href="{{ URL::to(@$vendordata->slug . '/find-order?order='.$orderdata->order_number) }}">
                                                <i class="fa-regular fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
