@extends('web.layout.default')

@section('contents')

    <!-- BREADCRUMB AREA START -->

    <section class="py-5 bg-light">
        <div class="container">
            <nav aria-label="breadcrumb">
                <h2 class="breadcrumb-title">{{ trans('labels.top_deals') }}</h2>
                <ol class="breadcrumb justify-content-center">
                    <li class="{{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : ' breadcrumb-item ' }}"><a
                            class="text-dark" href="{{ URL::to(@$vendordata->slug . '/') }}">{{ trans('labels.home') }}</a>
                    </li>
                    <li class="text-muted {{ session()->get('direction') == 2 ? 'breadcrumb-item-rtl' : ' breadcrumb-item ' }} active"
                        aria-current="page">{{ trans('labels.top_deals') }}</li>
                </ol>
            </nav>
        </div>
    </section>
    <!-- BREADCRUMB AREA END -->

    <!-- PRODUCTS LIST AREA START -->
    <section class="product-list">
        <div class="container py-5">
            <div id="topdeals">
                <div id="countdown" class="mb-5"></div>
                @if (count($topdealsproducts) > 0)
                    <div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 row-cols-lg-5 list-view">
                        @foreach ($topdealsproducts as $getproductdata)
                            @include('web.productcommonview')
                        @endforeach

                    </div>
                @else
                    @include('web.nodata')
                @endif

                {{ $topdealsproducts->appends(request()->query())->links() }}
            </div>
            <div id="nodata" class="d-none">
                @include('web.nodata')
            </div>
        </div>

    </section>

    <!-- PRODUCTS LIST AREA END -->

@endsection

@section('scripts')
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/products.js') }}"></script>
    <script src="{{ url(env('ASSETPATHURL') . 'web-assets/js/top_deals.js') }}"></script>
@endsection
