<?php

use Illuminate\Support\Facades\Route;
use App\helper\helper;
use App\Http\Controllers\admin\AdminController;
use App\Http\Controllers\admin\PlanPricingController;
use App\Http\Controllers\admin\GalleryController;
use App\Http\Controllers\admin\CategoryController;
use App\Http\Controllers\admin\SubCategoryController;
use App\Http\Controllers\admin\ProductController;
use App\Http\Controllers\admin\PaymentController;
use App\Http\Controllers\admin\TransactionController;
use App\Http\Controllers\admin\BannerController;
use App\Http\Controllers\addons\BlogController;
use App\Http\Controllers\admin\HowItWorkController;
use App\Http\Controllers\admin\ThemeController;
use App\Http\Controllers\admin\LangController;
use App\Http\Controllers\admin\ShippingareaController;
use App\Http\Controllers\admin\VendorController;
use App\Http\Controllers\admin\OrderController;
use App\Http\Controllers\admin\SystemAddonsController;
use App\Http\Controllers\admin\OtherPagesController;
use App\Http\Controllers\admin\WhoWeAreController;
use App\Http\Controllers\admin\TestimonialController;
use App\Http\Controllers\admin\FeaturesController;
use App\Http\Controllers\admin\WebSettingsController;
use App\Http\Controllers\landing\HomeController as LandingHomeController;
use App\Http\Controllers\web\HomeController;
use App\Http\Controllers\web\CartController;
use App\Http\Controllers\web\UserController as WebUserController;
use App\Http\Controllers\web\CheckoutController;
use App\Http\Controllers\web\ProductController as WebProductController;
use App\Http\Controllers\web\OtherPagesController as WebOtherPagesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//  ------------------------------- ----------- -----------------------------------------   //
//  -------------------------------  for Admin  -----------------------------------------   //
//  ------------------------------- ----------- -----------------------------------------   //	


$domain = env('WEBSITE_HOST');
$parsedUrl = parse_url(url()->current());
$host = $parsedUrl['host'];
if (array_key_exists('host', $parsedUrl)) {
    // if it is a path based URL
    if ($host == env('WEBSITE_HOST')) {
        $domain = $domain;
        $prefix = '{vendor_slug}';
    }
    // if it is a subdomain / custom domain
    else {
        $prefix = '';
    }
}
if ($host == env('WEBSITE_HOST')) {
    Route::get('/', [AdminController::class, 'login']);
    Route::group(['namespace' => 'admin', 'prefix' => 'admin'], function () {
        Route::get('/', [AdminController::class, 'login']);
        Route::post('checklogin', [AdminController::class, 'check_admin_login']);
        Route::get('register', [VendorController::class, 'register']);
        Route::post('/getcity', [VendorController::class, 'getcity']);
        Route::post('register_vendor', [VendorController::class, 'register_vendor']);
        Route::get('forgot_password', [VendorController::class, 'forgot_password']);
        Route::post('send_password', [VendorController::class, 'send_password']);
        Route::get('/verify', function () {
            return view('admin.auth.verify');
        });
        Route::post('systemverification', [AdminController::class, 'systemverification'])->name('admin.systemverification');
        Route::get('apps', [SystemAddonsController::class, 'index'])->name('systemaddons');
        Route::get('createsystem-addons', [SystemAddonsController::class, 'createsystemaddons']);
        Route::post('systemaddons/store', [SystemAddonsController::class, 'store']);
        Route::get('systemaddons/status-{id}/{status}', [SystemAddonsController::class, 'change_status']);


        Route::group(
            ['middleware' => 'AuthMiddleware'],
            function () {
                // -------- Common --------
                Route::get('admin_back', [VendorController::class, 'admin_back']);
                Route::get('logout', [AdminController::class, 'logout']);
                Route::get('dashboard', [AdminController::class, 'index']);
                // Settings
                Route::get('settings', [VendorController::class, 'settings_index']);
                Route::post('settings/update', [VendorController::class, 'settings_update']);
                Route::get('settings/delete-feature-{id}', [VendorController::class, 'delete_feature']);
                Route::post('settings/update-profile-{slug}', [VendorController::class, 'update']);
                Route::post('settings/change-password', [VendorController::class, 'change_password']);

                // Transaction
                Route::get('transaction', [TransactionController::class, 'index']);
                // Plans
                Route::get('plan', [PlanPricingController::class, 'view_plan']);
                Route::get('transaction/plandetails-{id}', [PlanPricingController::class, 'plan_details']);
                Route::get('transaction/generatepdf-{id}', [PlanPricingController::class, 'generatepdf']);

                // Payment
                Route::group(
                    ['prefix' => 'payment'],
                    function () {
                        Route::get('/', [PaymentController::class, 'index']);
                        Route::post('update', [PaymentController::class, 'update']);
                    }
                );

                // inquiries
                Route::get('/inquiries', [OtherPagesController::class, 'inquiries']);
                Route::get('/inquiries/delete-{id}', [OtherPagesController::class, 'inquiries_delete']);


                // Other Pages
                Route::get('/subscribers', [OtherPagesController::class, 'subscribers']);
                Route::get('/subscribers/delete-{id}', [OtherPagesController::class, 'subscribers_delete']);

                Route::get('/privacypolicy', [OtherPagesController::class, 'privacypolicy']);

                Route::post('/privacypolicy/update', [OtherPagesController::class, 'update_privacypolicy']);

                Route::get('/termscondition', [OtherPagesController::class, 'termscondition']);

                Route::post('/termscondition/update', [OtherPagesController::class, 'update_terms']);

                Route::get('/aboutus', [OtherPagesController::class, 'aboutus']);

                Route::post('/aboutus/update', [OtherPagesController::class, 'update_aboutus']);
                Route::get('/refund_policy', [OtherPagesController::class, 'refund_policy']);
                Route::post('/refund_policy/update', [OtherPagesController::class, 'refund_policy_update']);
                Route::group(
                    ['prefix' => 'orders'],
                    function () {
                        Route::get('/invoice/{order_number}', [OrderController::class, 'invoice']);
                        Route::get('/generatepdf/{order_number}', [OrderController::class, 'generatepdf']);
                    }
                );

                // website settings
                Route::get('/basic_settings', [WebSettingsController::class, 'basic_settings']);
                Route::post('/themeupdate', [WebSettingsController::class, 'themeupdate']);
                Route::post('/seo_update', [WebSettingsController::class, 'seo_update']);
                Route::post('/footer_features/update', [WebSettingsController::class, 'footer_features_update']);

                Route::post('/contact_settings/update', [WebSettingsController::class, 'contact_settings']);
                Route::post('/other/update', [WebSettingsController::class, 'other_update']);
                Route::post('/top_deals/update', [WebSettingsController::class, 'top_deals']);


                //testimonial
                Route::group(
                    ['prefix' => 'testimonials'],
                    function () {
                        Route::get('/', [TestimonialController::class, 'index']);
                        Route::get('/add', [testimonialController::class, 'add']);
                        Route::post('/save', [testimonialController::class, 'save']);
                        Route::get('/edit-{id}', [testimonialController::class, 'edit']);
                        Route::post('/update-{id}', [testimonialController::class, 'update']);
                        Route::get('/delete-{id}', [testimonialController::class, 'delete']);
                    }
                );

                Route::post('app_section/update', [WebSettingsController::class, 'app_section']);
                Route::middleware('adminmiddleware')->group(
                    function () {
                        Route::get('transaction-{id}-{status}', [TransactionController::class, 'status']);
                        // Plan
                        Route::group(
                            ['prefix' => 'plan'],
                            function () {
                                Route::get('add', [PlanPricingController::class, 'add_plan']);
                                Route::post('save_plan', [PlanPricingController::class, 'save_plan']);
                                Route::get('edit-{id}', [PlanPricingController::class, 'edit_plan']);
                                Route::post('update_plan-{id}', [PlanPricingController::class, 'update_plan']);
                                Route::get('status_change-{id}/{status}', [PlanPricingController::class, 'status_change']);
                                Route::get('/delete-{id}', [PlanPricingController::class, 'delete']);
                                Route::post('/updateimage', [PlanPricingController::class, 'updateimage']);
                            }
                        );
                        // Users/Vendors
                        Route::group(
                            ['prefix' => 'users'],
                            function () {
                                Route::get('/', [VendorController::class, 'index']);
                                Route::get('add', [VendorController::class, 'add']);
                                Route::get('edit-{slug}', [VendorController::class, 'edit']);
                                Route::post('update-{slug}', [VendorController::class, 'update']);
                                Route::get('status-{slug}/{status}', [VendorController::class, 'status']);
                                Route::get('login-{slug}', [VendorController::class, 'vendor_login']);
                            }
                        );


                        //   FAQs
                        Route::group(
                            ['prefix' => 'faqs'],
                            function () {
                                Route::get('/', [OtherPagesController::class, 'faq_index']);
                                Route::get('/add', [OtherPagesController::class, 'faq_add']);
                                Route::post('/save', [OtherPagesController::class, 'faq_save']);
                                Route::get('/edit-{id}', [OtherPagesController::class, 'faq_edit']);
                                Route::post('/update-{id}', [OtherPagesController::class, 'faq_update']);
                                Route::get('/delete-{id}', [OtherPagesController::class, 'faq_delete']);
                            }
                        );

                        //features
                        Route::group(
                            ['prefix' => 'features'],
                            function () {
                                Route::get('/', [FeaturesController::class, 'index']);
                                Route::get('/add', [FeaturesController::class, 'add']);
                                Route::post('/save', [FeaturesController::class, 'save']);
                                Route::get('/edit-{id}', [FeaturesController::class, 'edit']);
                                Route::post('/update-{id}', [FeaturesController::class, 'update']);
                                Route::get('/delete-{id}', [FeaturesController::class, 'delete']);
                            }
                        );


                        // countries
                        Route::group(
                            ['prefix' => 'countries'],
                            function () {
                                Route::get('/', [OtherPagesController::class, 'countries']);
                                Route::get('/add', [OtherPagesController::class, 'add_country']);
                                Route::post('/save', [OtherPagesController::class, 'save_country']);
                                Route::get('/edit-{id}', [OtherPagesController::class, 'edit_country']);
                                Route::post('/update-{id}', [OtherPagesController::class, 'update_country']);
                                Route::get('/delete-{id}', [OtherPagesController::class, 'delete_country']);
                                Route::get('/change_status-{id}/{status}', [OtherPagesController::class, 'statuschange_country']);
                            }
                        );

                        // city
                        Route::group(
                            ['prefix' => 'cities'],
                            function () {
                                Route::get('/', [OtherPagesController::class, 'cities']);
                                Route::get('/add', [OtherPagesController::class, 'add_city']);
                                Route::post('/save', [OtherPagesController::class, 'save_city']);
                                Route::get('/edit-{id}', [OtherPagesController::class, 'edit_city']);
                                Route::post('/update-{id}', [OtherPagesController::class, 'update_city']);
                                Route::get('/delete-{id}', [OtherPagesController::class, 'delete_city']);
                                Route::get('/change_status-{id}/{status}', [OtherPagesController::class, 'statuschange_city']);
                            }
                        );

                        // promotional banner
                        Route::group(
                            ['prefix' => 'promotionalbanners'],
                            function () {
                                Route::get('/', [BannerController::class, 'promotional_banner']);
                                Route::get('add', [BannerController::class, 'promotional_banneradd']);
                                Route::get('edit-{id}', [BannerController::class, 'promotional_banneredit']);
                                Route::post('save', [BannerController::class, 'promotional_bannersave_banner']);
                                Route::post('update-{id}', [BannerController::class, 'promotional_bannerupdate']);
                                Route::get('delete-{id}', [BannerController::class, 'promotional_bannerdelete']);
                            }
                        );


                        Route::group(['prefix' => 'language-settings'], function () {
                            Route::get('/', [LangController::class, 'language']);
                            Route::post('/update', [LangController::class, 'storeLanguageData']);
                            Route::get('/language/edit-{id}', [LangController::class, 'edit']);
                            Route::post('/update-{id}', [LangController::class, 'update']);
                            Route::get('/layout/update-{id}/{status}', [LangController::class, 'layout']);
                            Route::get('/layout/status-{id}/{status}', [LangController::class, 'status']);
                        });

                        Route::post('/fun_fact/update', [WebSettingsController::class, 'fun_fact_update']);
                        Route::get('/fun_fact/delete-{id}', [WebSettingsController::class, 'fun_fact_delete']);

                        // theme
                        Route::get('/themes', [ThemeController::class, 'index']);
                        Route::get('themes/add', [ThemeController::class, 'add']);
                        Route::post('/themes/save', [ThemeController::class, 'save']);
                        Route::get('/themes/edit-{id}', [ThemeController::class, 'edit']);
                        Route::post('/themes/update-{id}', [ThemeController::class, 'update']);
                        Route::get('/themes/delete-{id}', [ThemeController::class, 'delete']);

                        Route::get('/how_it_works', [HowItWorkController::class, 'index']);
                        Route::get('/how_it_works/add', [HowItWorkController::class, 'add']);
                        Route::get('/how_it_works/edit-{id}', [HowItWorkController::class, 'edit']);
                        Route::post('/how_it_works/save', [HowItWorkController::class, 'save']);
                        Route::post('/how_it_works/update-{id}', [HowItWorkController::class, 'update']);
                        Route::get('/how_it_works/delete-{id}', [HowItWorkController::class, 'delete']);
                    }
                );
                Route::middleware('VendorMiddleware')->group(
                    function () {
                        Route::get('settings/delete-banner', [VendorController::class, 'delete_viewall_page_image']);

                        Route::get('/deleteaccount-{id}', [VendorController::class, 'deleteaccount']);
                        // share
                        Route::get('share', [OtherPagesController::class, 'share']);

                        // Orders
                        Route::get('/report', [OrderController::class, 'index']);

                        Route::group(
                            ['prefix' => 'orders'],
                            function () {
                                Route::get('/', [OrderController::class, 'index']);
                                Route::get('/update-{id}-{status}', [OrderController::class, 'update']);

                                Route::get('/print/{order_number}', [OrderController::class, 'print']);
                            }
                        );
                        // Shipping-area
                        Route::group(
                            ['prefix' => 'shipping-area'],
                            function () {
                                Route::get('/', [ShippingareaController::class, 'index']);
                                Route::get('add', [ShippingareaController::class, 'add']);
                                Route::get('show-{id}', [ShippingareaController::class, 'show']);
                                Route::post('store', [ShippingareaController::class, 'store']);
                                Route::post('update-{id}', [ShippingareaController::class, 'store']);
                                Route::get('status-{id}-{status}', [ShippingareaController::class, 'status']);
                                Route::get('delete-{id}', [ShippingareaController::class, 'delete']);
                            }
                        );
                        // Categories
                        Route::group(
                            ['prefix' => 'categories'],
                            function () {
                                Route::get('/', [CategoryController::class, 'index']);
                                Route::get('add', [CategoryController::class, 'add_category']);
                                Route::post('save', [CategoryController::class, 'save_category']);
                                Route::get('edit-{slug}', [CategoryController::class, 'edit_category']);
                                Route::post('update-{slug}', [CategoryController::class, 'update_category']);
                                Route::get('change_status-{slug}/{status}', [CategoryController::class, 'change_status']);
                                Route::get('delete-{slug}', [CategoryController::class, 'delete_category']);
                                Route::post('/reorder_category', [CategoryController::class, 'reorder_category']);
                            }
                        );
                        // Sub Categories
                        Route::group(
                            ['prefix' => 'sub-categories'],
                            function () {
                                Route::get('/', [SubCategoryController::class, 'index']);
                                Route::get('add', [SubCategoryController::class, 'add']);
                                Route::post('store', [SubCategoryController::class, 'store']);
                                Route::get('edit-{slug}', [SubCategoryController::class, 'edit']);
                                Route::post('update-{slug}', [SubCategoryController::class, 'update']);
                                Route::get('change_status-{slug}/{status}', [SubCategoryController::class, 'change_status']);
                                Route::get('delete-{slug}', [SubCategoryController::class, 'delete']);
                                Route::post('/reorder_category', [SubCategoryController::class, 'subcategory_reorder']);
                            }
                        );
                        // Products
                        Route::get('/generatepdf', [ProductController::class, 'generatepdf']);
                        Route::get('/generatepdf_subcategory', [ProductController::class, 'generatepdf_subcategory']);
                        Route::post('/importproduct', [ProductController::class, 'importproduct']);
                        Route::group(
                            ['prefix' => 'products'],
                            function () {
                                Route::get('/', [ProductController::class, 'index']);
                                Route::get('add', [ProductController::class, 'add']);
                                Route::post('save', [ProductController::class, 'save']);
                                Route::get('edit-{slug}', [ProductController::class, 'edit']);
                                Route::post('update-{slug}', [ProductController::class, 'update_product']);
                                Route::get('delete-{slug}', [ProductController::class, 'delete_product']);
                                Route::post('update', [ProductController::class, 'update_image']);
                                Route::get('delete_image-{id}/{service_id}', [ProductController::class, 'delete_image']);
                                Route::get('deletevariation-{id}-{product_id}', [ProductController::class, 'delete_variation']);
                                Route::post('add_image', [ProductController::class, 'add_image']);
                                Route::get('status_change-{slug}/{status}', [ProductController::class, 'status_change']);
                                Route::get('/top_deals-{slug}/{status}', [ProductController::class, 'top_deals']);
                                Route::get('subcategories', [ProductController::class, 'subcategories']);
                                Route::get('/import', [ProductController::class, 'import']);
                                Route::post('/reorder_category', [ProductController::class, 'reorder_category']);
                                Route::get('/review/delete-{id}', [ProductController::class, 'delete_review']);
                            }
                        );
                        // Plan
                        Route::group(
                            ['prefix' => 'plan'],
                            function () {
                                Route::get('selectplan-{id}', [PlanPricingController::class, 'select_plan']);
                                Route::post('buyplan', [PlanPricingController::class, 'buyplan']);
                                Route::get('buyplan/mercadorequest/success', [PlanPricingController::class, 'success']);
                                Route::get('buyplan/paypalrequest/success', [PlanPricingController::class, 'success']);
                                Route::get('buyplan/myfatoorahrequest/success', [PlanPricingController::class, 'success']);
                            }
                        );
                        // Banners
                        Route::group(
                            ['prefix' => 'bannersection-1'],
                            function () {
                                Route::get('/', [BannerController::class, 'index']);
                                Route::get('add', [BannerController::class, 'add']);
                                Route::get('edit-{id}', [BannerController::class, 'edit']);
                                Route::post('save', [BannerController::class, 'save_banner']);
                                Route::post('update-{id}', [BannerController::class, 'edit_banner']);
                                Route::get('status_change-{id}/{status}', [BannerController::class, 'status_update']);
                                Route::get('delete-{id}', [BannerController::class, 'delete']);
                            }
                        );
                        Route::group(
                            ['prefix' => 'bannersection-2'],
                            function () {
                                Route::get('/', [BannerController::class, 'index']);
                                Route::get('add', [BannerController::class, 'add']);
                                Route::get('edit-{id}', [BannerController::class, 'edit']);
                                Route::post('save', [BannerController::class, 'save_banner']);
                                Route::post('update-{id}', [BannerController::class, 'edit_banner']);
                                Route::get('status_change-{id}/{status}', [BannerController::class, 'status_update']);
                                Route::get('delete-{id}', [BannerController::class, 'delete']);
                            }
                        );
                        Route::group(
                            ['prefix' => 'bannersection-3'],
                            function () {
                                Route::get('/', [BannerController::class, 'index']);
                                Route::get('add', [BannerController::class, 'add']);
                                Route::get('edit-{id}', [BannerController::class, 'edit']);
                                Route::post('save', [BannerController::class, 'save_banner']);
                                Route::post('update-{id}', [BannerController::class, 'edit_banner']);
                                Route::get('status_change-{id}/{status}', [BannerController::class, 'status_update']);
                                Route::get('delete-{id}', [BannerController::class, 'delete']);
                            }
                        );
                        Route::group(
                            ['prefix' => 'sliders'],
                            function () {
                                Route::get('/', [BannerController::class, 'index']);
                                Route::get('add', [BannerController::class, 'add']);
                                Route::get('edit-{id}', [BannerController::class, 'edit']);
                                Route::post('save', [BannerController::class, 'save_banner']);
                                Route::post('update-{id}', [BannerController::class, 'edit_banner']);
                                Route::get('status_change-{id}/{status}', [BannerController::class, 'status_update']);
                                Route::get('delete-{id}', [BannerController::class, 'delete']);
                            }
                        );
                        Route::get('/whoweare', [WhoWeAreController::class, 'index']);
                        Route::get('/whoweare/add', [WhoWeAreController::class, 'add']);
                        Route::get('/whoweare/edit-{id}', [WhoWeAreController::class, 'edit']);
                        Route::post('/whoweare/savecontent', [WhoWeAreController::class, 'savecontent']);
                        Route::post('/whoweare/save', [WhoWeAreController::class, 'save']);
                        Route::post('/whoweare/update-{id}', [WhoWeAreController::class, 'update']);
                        Route::get('/whoweare/status_change-{id}/{status}', [WhoWeAreController::class, 'status_update']);
                        Route::get('/whoweare/delete-{id}', [WhoWeAreController::class, 'delete']);

                        // Gallery
                        Route::get('/gallery', [GalleryController::class, 'index']);
                        Route::get('/gallery/add', [GalleryController::class, 'add']);
                        Route::post('/gallery/save', [GalleryController::class, 'save']);
                        Route::get('/gallery/edit-{id}', [GalleryController::class, 'edit']);
                        Route::post('/gallery/update-{id}', [GalleryController::class, 'update']);
                        Route::get('/gallery/delete-{id}', [GalleryController::class, 'delete']);
                    }
                );
            }
        );
    });
}

//  ------------------------------- ----------- -----------------------------------------   //
//  -------------------------------  for Web/Front  -------------------------------------   //
//  ------------------------------- ----------- -----------------------------------------   //
Route::group(['namespace' => '', 'middleware' => 'landingMiddleware'], function () {
    if (@helper::appdata('')->landing_page == 1) {
        Route::get('/', [LandingHomeController::class, 'index']);
    }
    Route::post('/emailsubscribe', [LandingHomeController::class, 'emailsubscribe']);
    Route::post('/inquiry', [LandingHomeController::class, 'inquiry']);
    Route::get('/aboutus', [LandingHomeController::class, 'aboutus']);
    Route::get('/privacypolicy', [LandingHomeController::class, 'privacypolicy']);
    Route::get('/refund_policy', [LandingHomeController::class, 'refund_policy']);
    Route::get('/termscondition', [LandingHomeController::class, 'termscondition']);
    Route::get('/blogdetail-{slug}', [BlogController::class, 'pageblogdetail']);
    Route::get('/blogs', [BlogController::class, 'allblogs']);
    Route::get('/faqs', [LandingHomeController::class, 'faqs']);
    Route::get('/contact', [LandingHomeController::class, 'contact']);
    Route::get('/stores', [LandingHomeController::class, 'allstores']);
    Route::post('/getcity', [AdminController::class, 'getcity']);
});



Route::get('lang/change', [LangController::class, 'change'])->name('changeLang');
Route::group(['namespace' => "web", 'prefix' => $prefix, 'middleware' => 'FrontMiddleware'], function () {

    Route::get('/', [HomeController::class, 'index']);
    Route::get('/categories', [HomeController::class, 'categories']);
    Route::get('/checkvendor', [HomeController::class, 'checkvendor']);

    Route::post('/managefavorite', [HomeController::class, 'managefavorite']);

    // product-search-filter
    Route::get('/category', [WebProductController::class, 'category_wise_products']);
    Route::get('/categories-{category_slug}/subcategory-{subcategory_slug}', [WebProductController::class, 'category_wise_products']);
    Route::get('/products', [WebProductController::class, 'category_wise_products']);
    Route::get('/products-{type}', [WebProductController::class, 'category_wise_products']);
    Route::get('/products/{product_slug}', [WebProductController::class, 'productdetails']);
    Route::get('/topdeals', [WebProductController::class, 'alltopdeals']);
    // Cart
    Route::get('/cart', [CartController::class, 'index']);
    Route::get('/cart/clear', [CartController::class, 'clearcart']);
    Route::get('/cart/clear-{pid}-{vid}', [CartController::class, 'clearcart']);
    Route::get('/cart/qtyupdate-{pid}-{vid}-{type}', [CartController::class, 'qtyupdate']);

    Route::post('/cart/add', [CartController::class, 'addtocart']);
    // checkout-orders
    Route::get('/checkout', [CheckoutController::class, 'index']);
    Route::post('/checkout/orderlimit', [CheckoutController::class, 'orderlimit']);
    Route::post('/checkout/placeorder', [CheckoutController::class, 'placeorder']);

    Route::get('/checkout/placeorder/success', [CheckoutController::class, 'paymentrequestsuccess']);
    Route::get('/orders-success-{order_number}', [CheckoutController::class, 'ordersuccess']);
    Route::get('/find-order', [CheckoutController::class, 'orderdetails']);
    Route::get('/orders-cancel-{order_number}', [CheckoutController::class, 'cancelorder']);
    // other-pages

    Route::get('/contact-us', [WebOtherPagesController::class, 'contact_us']);
    Route::post('/contact-us/store', [WebOtherPagesController::class, 'contact_store']);
    Route::post('/subscribe', [WebOtherPagesController::class, 'subscribe']);

    // legal
    Route::get('/termscondition', [WebOtherPagesController::class, 'termscondition']);
    Route::get('/privacypolicy', [WebOtherPagesController::class, 'privacypolicy']);
    Route::get('/aboutus', [WebOtherPagesController::class, 'aboutus']);
    Route::get('/refund_policy', [WebOtherPagesController::class, 'refund_policy']);
    // Login Page
    Route::get('/login', [WebUserController::class, 'user_login']);
    Route::get('/register', [WebUserController::class, 'user_register']);
    Route::post('/checklogin-{logintype}', [WebUserController::class, 'check_login']);
    Route::post('/register_customer', [WebUserController::class, 'register_customer']);
    Route::get('/forgotpassword', [WebUserController::class, 'userforgotpassword']);
    Route::post('/send_userpassword', [WebUserController::class, 'send_userpassword']);
    Route::get('/logout', [WebUserController::class, 'logout']);
    Route::get('/deleteaccount', [WebUserController::class, 'deleteaccount']);
    Route::get('/deleteprofile', [WebUserController::class, 'deleteprofile']);

    //User profile
    Route::get('/profile', [WebUserController::class, 'my_profile']);
    Route::post('/editprofile', [WebUserController::class, 'edit_profile']);

    Route::get('/change-password', [WebUserController::class, 'changepassword']);
    Route::post('/updatepassword', [WebUserController::class, 'updatepassword']);
    Route::get('/orders', [WebUserController::class, 'orders']);
    Route::get('/favourite', [WebUserController::class, 'wishlist_product']);

    Route::get('/getproductdata', [WebProductController::class, 'getproductdata']);
    Route::get('/shop_all', [WebProductController::class, 'category_wise_products']);
    Route::get('/gallery', [WebOtherPagesController::class, 'gallery']);
    Route::post('/postreview', [WebProductController::class, 'postreview']);
    Route::get('/category', [WebProductController::class, 'category_wise_products']);
});